/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.conjure.api;

import com.palantir.gradle.conjure.api.EndpointVersionBound;
import com.palantir.gradle.conjure.api.ServiceDependency;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;

public class ConjureProductDependenciesExtension {
    public static final String EXTENSION_NAME = "serviceDependencies";
    public static final String ENDPOINT_VERSIONS_MANIFEST_KEY = "Endpoint-Version-Bounds";
    private final Project project;
    private final Set<ServiceDependency> productDependencies = new HashSet<ServiceDependency>();
    private final SetProperty<EndpointVersionBound> endpointVersions;
    private final ProviderFactory providerFactory;

    @Inject
    public ConjureProductDependenciesExtension(Project project) {
        this.project = project;
        this.endpointVersions = project.getObjects().setProperty(EndpointVersionBound.class).empty();
        this.providerFactory = project.getProviders();
    }

    public final Set<ServiceDependency> getProductDependencies() {
        return this.productDependencies;
    }

    public final void serviceDependency(@DelegatesTo(value=ServiceDependency.class) Closure<ServiceDependency> closure) {
        ServiceDependency serviceDependency = new ServiceDependency();
        closure.setDelegate((Object)serviceDependency);
        closure.call();
        this.productDependencies.add(serviceDependency);
    }

    public final void endpointVersion(@DelegatesTo(value=EndpointVersionBound.class) Closure<?> closure) {
        this.endpointVersions.add(this.providerFactory.provider(() -> {
            EndpointVersionBound evb = new EndpointVersionBound();
            this.project.configure((Object)evb, closure);
            return evb;
        }));
    }

    public final SetProperty<EndpointVersionBound> getEndpointVersions() {
        return this.endpointVersions;
    }
}

