/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public final class Versions {
    private final Optional<String> dockerComposeRule;
    private final Optional<String> docker;
    private final Optional<String> dockerCompose;
    private volatile int memoizedHashCode;

    private Versions(Optional<String> dockerComposeRule, Optional<String> docker, Optional<String> dockerCompose) {
        Versions.validateFields(dockerComposeRule, docker, dockerCompose);
        this.dockerComposeRule = dockerComposeRule;
        this.docker = docker;
        this.dockerCompose = dockerCompose;
    }

    @JsonProperty(value="dockerComposeRule")
    public Optional<String> getDockerComposeRule() {
        return this.dockerComposeRule;
    }

    @JsonProperty(value="docker")
    public Optional<String> getDocker() {
        return this.docker;
    }

    @JsonProperty(value="dockerCompose")
    public Optional<String> getDockerCompose() {
        return this.dockerCompose;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Versions && this.equalTo((Versions)other);
    }

    private boolean equalTo(Versions other) {
        return this.dockerComposeRule.equals(other.dockerComposeRule) && this.docker.equals(other.docker) && this.dockerCompose.equals(other.dockerCompose);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = Objects.hash(this.dockerComposeRule, this.docker, this.dockerCompose);
        }
        return result;
    }

    public String toString() {
        return "Versions{dockerComposeRule: " + this.dockerComposeRule + ", docker: " + this.docker + ", dockerCompose: " + this.dockerCompose + '}';
    }

    public static Versions of(String dockerComposeRule, String docker, String dockerCompose) {
        return Versions.builder().dockerComposeRule(Optional.of(dockerComposeRule)).docker(Optional.of(docker)).dockerCompose(Optional.of(dockerCompose)).build();
    }

    private static void validateFields(Optional<String> dockerComposeRule, Optional<String> docker, Optional<String> dockerCompose) {
        List<String> missingFields = null;
        missingFields = Versions.addFieldIfMissing(missingFields, dockerComposeRule, "dockerComposeRule");
        missingFields = Versions.addFieldIfMissing(missingFields, docker, "docker");
        if ((missingFields = Versions.addFieldIfMissing(missingFields, dockerCompose, "dockerCompose")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> dockerComposeRule = Optional.empty();
        private Optional<String> docker = Optional.empty();
        private Optional<String> dockerCompose = Optional.empty();

        private Builder() {
        }

        public Builder from(Versions other) {
            this.dockerComposeRule(other.getDockerComposeRule());
            this.docker(other.getDocker());
            this.dockerCompose(other.getDockerCompose());
            return this;
        }

        @JsonSetter(value="dockerComposeRule", nulls=Nulls.SKIP)
        public Builder dockerComposeRule(@Nonnull Optional<String> dockerComposeRule) {
            this.dockerComposeRule = (Optional)Preconditions.checkNotNull(dockerComposeRule, (String)"dockerComposeRule cannot be null");
            return this;
        }

        public Builder dockerComposeRule(@Nonnull String dockerComposeRule) {
            this.dockerComposeRule = Optional.of((String)Preconditions.checkNotNull((Object)dockerComposeRule, (String)"dockerComposeRule cannot be null"));
            return this;
        }

        @JsonSetter(value="docker", nulls=Nulls.SKIP)
        public Builder docker(@Nonnull Optional<String> docker) {
            this.docker = (Optional)Preconditions.checkNotNull(docker, (String)"docker cannot be null");
            return this;
        }

        public Builder docker(@Nonnull String docker) {
            this.docker = Optional.of((String)Preconditions.checkNotNull((Object)docker, (String)"docker cannot be null"));
            return this;
        }

        @JsonSetter(value="dockerCompose", nulls=Nulls.SKIP)
        public Builder dockerCompose(@Nonnull Optional<String> dockerCompose) {
            this.dockerCompose = (Optional)Preconditions.checkNotNull(dockerCompose, (String)"dockerCompose cannot be null");
            return this;
        }

        public Builder dockerCompose(@Nonnull String dockerCompose) {
            this.dockerCompose = Optional.of((String)Preconditions.checkNotNull((Object)dockerCompose, (String)"dockerCompose cannot be null"));
            return this;
        }

        public Versions build() {
            return new Versions(this.dockerComposeRule, this.docker, this.dockerCompose);
        }
    }
}

