/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.docker.compose.events.Task;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public final class PullEvent {
    private final Task task;

    private PullEvent(Task task) {
        PullEvent.validateFields(task);
        this.task = task;
    }

    @JsonProperty(value="task")
    public Task getTask() {
        return this.task;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof PullEvent && this.equalTo((PullEvent)other);
    }

    private boolean equalTo(PullEvent other) {
        return this.task.equals(other.task);
    }

    public int hashCode() {
        return Objects.hashCode(this.task);
    }

    public String toString() {
        return "PullEvent{task: " + this.task + '}';
    }

    public static PullEvent of(Task task) {
        return PullEvent.builder().task(task).build();
    }

    private static void validateFields(Task task) {
        List<String> missingFields = null;
        if ((missingFields = PullEvent.addFieldIfMissing(missingFields, task, "task")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Task task;

        private Builder() {
        }

        public Builder from(PullEvent other) {
            this.task(other.getTask());
            return this;
        }

        @JsonSetter(value="task")
        public Builder task(@Nonnull Task task) {
            this.task = (Task)Preconditions.checkNotNull((Object)task, (String)"task cannot be null");
            return this;
        }

        public PullEvent build() {
            return new PullEvent(this.task);
        }
    }
}

