/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class Task {
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;
    private final Optional<String> failure;
    private volatile int memoizedHashCode;

    private Task(OffsetDateTime startTime, OffsetDateTime endTime, Optional<String> failure) {
        Task.validateFields(startTime, endTime, failure);
        this.startTime = startTime;
        this.endTime = endTime;
        this.failure = failure;
    }

    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="endTime")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="failure")
    public Optional<String> getFailure() {
        return this.failure;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Task && this.equalTo((Task)other);
    }

    private boolean equalTo(Task other) {
        return this.startTime.isEqual(other.startTime) && this.endTime.isEqual(other.endTime) && this.failure.equals(other.failure);
    }

    public int hashCode() {
        if (this.memoizedHashCode == 0) {
            this.memoizedHashCode = Objects.hash(this.startTime.toInstant(), this.endTime.toInstant(), this.failure);
        }
        return this.memoizedHashCode;
    }

    public String toString() {
        return "Task" + '{' + "startTime" + ": " + this.startTime + ", " + "endTime" + ": " + this.endTime + ", " + "failure" + ": " + this.failure + '}';
    }

    public static Task of(OffsetDateTime startTime, OffsetDateTime endTime, String failure) {
        return Task.builder().startTime(startTime).endTime(endTime).failure(Optional.of(failure)).build();
    }

    private static void validateFields(OffsetDateTime startTime, OffsetDateTime endTime, Optional<String> failure) {
        List<String> missingFields = null;
        missingFields = Task.addFieldIfMissing(missingFields, startTime, "startTime");
        missingFields = Task.addFieldIfMissing(missingFields, endTime, "endTime");
        if ((missingFields = Task.addFieldIfMissing(missingFields, failure, "failure")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private Optional<String> failure = Optional.empty();

        private Builder() {
        }

        public Builder from(Task other) {
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.failure(other.getFailure());
            return this;
        }

        @JsonSetter(value="startTime")
        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = (OffsetDateTime)Preconditions.checkNotNull((Object)startTime, (String)"startTime cannot be null");
            return this;
        }

        @JsonSetter(value="endTime")
        public Builder endTime(OffsetDateTime endTime) {
            this.endTime = (OffsetDateTime)Preconditions.checkNotNull((Object)endTime, (String)"endTime cannot be null");
            return this;
        }

        @JsonSetter(value="failure", nulls=Nulls.SKIP)
        public Builder failure(Optional<String> failure) {
            this.failure = (Optional)Preconditions.checkNotNull(failure, (String)"failure cannot be null");
            return this;
        }

        public Builder failure(String failure) {
            this.failure = Optional.of((String)Preconditions.checkNotNull((Object)failure, (String)"failure cannot be null"));
            return this;
        }

        public Task build() {
            return new Task(this.startTime, this.endTime, this.failure);
        }
    }
}

