/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.docker.compose.events.BuildEvent;
import com.palantir.docker.compose.events.ClusterWaitEvent;
import com.palantir.docker.compose.events.LogCollectionEvent;
import com.palantir.docker.compose.events.PullEvent;
import com.palantir.docker.compose.events.ShutdownEvent;
import com.palantir.docker.compose.events.ShutdownStopEvent;
import com.palantir.docker.compose.events.UpEvent;
import com.palantir.docker.compose.events.WaitForServicesEvent;
import com.palantir.logsafe.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class Event {
    private final Base value;

    @JsonCreator
    private Event(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static Event build(BuildEvent value) {
        return new Event(new BuildWrapper(value));
    }

    public static Event pull(PullEvent value) {
        return new Event(new PullWrapper(value));
    }

    public static Event up(UpEvent value) {
        return new Event(new UpWrapper(value));
    }

    public static Event waitForServices(WaitForServicesEvent value) {
        return new Event(new WaitForServicesWrapper(value));
    }

    public static Event clusterWait(ClusterWaitEvent value) {
        return new Event(new ClusterWaitWrapper(value));
    }

    public static Event shutdownStop(ShutdownStopEvent value) {
        return new Event(new ShutdownStopWrapper(value));
    }

    public static Event logCollection(LogCollectionEvent value) {
        return new Event(new LogCollectionWrapper(value));
    }

    public static Event shutdown(ShutdownEvent value) {
        return new Event(new ShutdownWrapper(value));
    }

    public <T> T accept(Visitor<T> visitor) {
        if (this.value instanceof BuildWrapper) {
            return visitor.visitBuild(((BuildWrapper)this.value).value);
        }
        if (this.value instanceof PullWrapper) {
            return visitor.visitPull(((PullWrapper)this.value).value);
        }
        if (this.value instanceof UpWrapper) {
            return visitor.visitUp(((UpWrapper)this.value).value);
        }
        if (this.value instanceof WaitForServicesWrapper) {
            return visitor.visitWaitForServices(((WaitForServicesWrapper)this.value).value);
        }
        if (this.value instanceof ClusterWaitWrapper) {
            return visitor.visitClusterWait(((ClusterWaitWrapper)this.value).value);
        }
        if (this.value instanceof ShutdownStopWrapper) {
            return visitor.visitShutdownStop(((ShutdownStopWrapper)this.value).value);
        }
        if (this.value instanceof LogCollectionWrapper) {
            return visitor.visitLogCollection(((LogCollectionWrapper)this.value).value);
        }
        if (this.value instanceof ShutdownWrapper) {
            return visitor.visitShutdown(((ShutdownWrapper)this.value).value);
        }
        if (this.value instanceof UnknownWrapper) {
            return visitor.visitUnknown(((UnknownWrapper)this.value).getType());
        }
        throw new IllegalStateException(String.format("Could not identify type %s", this.value.getClass()));
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Event && this.equalTo((Event)other);
    }

    private boolean equalTo(Event other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Event" + '{' + "value" + ": " + this.value + '}';
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
    private static class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(String type, Map<String, Object> value) {
            Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
            Preconditions.checkNotNull(value, (String)"value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "UnknownWrapper" + '{' + "type" + ": " + this.type + ", " + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="shutdown")
    private static class ShutdownWrapper
    implements Base {
        private final ShutdownEvent value;

        @JsonCreator
        private ShutdownWrapper(@JsonProperty(value="shutdown") ShutdownEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"shutdown cannot be null");
            this.value = value;
        }

        @JsonProperty(value="shutdown")
        private ShutdownEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ShutdownWrapper && this.equalTo((ShutdownWrapper)other);
        }

        private boolean equalTo(ShutdownWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ShutdownWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="logCollection")
    private static class LogCollectionWrapper
    implements Base {
        private final LogCollectionEvent value;

        @JsonCreator
        private LogCollectionWrapper(@JsonProperty(value="logCollection") LogCollectionEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"logCollection cannot be null");
            this.value = value;
        }

        @JsonProperty(value="logCollection")
        private LogCollectionEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof LogCollectionWrapper && this.equalTo((LogCollectionWrapper)other);
        }

        private boolean equalTo(LogCollectionWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "LogCollectionWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="shutdownStop")
    private static class ShutdownStopWrapper
    implements Base {
        private final ShutdownStopEvent value;

        @JsonCreator
        private ShutdownStopWrapper(@JsonProperty(value="shutdownStop") ShutdownStopEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"shutdownStop cannot be null");
            this.value = value;
        }

        @JsonProperty(value="shutdownStop")
        private ShutdownStopEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ShutdownStopWrapper && this.equalTo((ShutdownStopWrapper)other);
        }

        private boolean equalTo(ShutdownStopWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ShutdownStopWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="clusterWait")
    private static class ClusterWaitWrapper
    implements Base {
        private final ClusterWaitEvent value;

        @JsonCreator
        private ClusterWaitWrapper(@JsonProperty(value="clusterWait") ClusterWaitEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"clusterWait cannot be null");
            this.value = value;
        }

        @JsonProperty(value="clusterWait")
        private ClusterWaitEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ClusterWaitWrapper && this.equalTo((ClusterWaitWrapper)other);
        }

        private boolean equalTo(ClusterWaitWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ClusterWaitWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="waitForServices")
    private static class WaitForServicesWrapper
    implements Base {
        private final WaitForServicesEvent value;

        @JsonCreator
        private WaitForServicesWrapper(@JsonProperty(value="waitForServices") WaitForServicesEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"waitForServices cannot be null");
            this.value = value;
        }

        @JsonProperty(value="waitForServices")
        private WaitForServicesEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof WaitForServicesWrapper && this.equalTo((WaitForServicesWrapper)other);
        }

        private boolean equalTo(WaitForServicesWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "WaitForServicesWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="up")
    private static class UpWrapper
    implements Base {
        private final UpEvent value;

        @JsonCreator
        private UpWrapper(@JsonProperty(value="up") UpEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"up cannot be null");
            this.value = value;
        }

        @JsonProperty(value="up")
        private UpEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof UpWrapper && this.equalTo((UpWrapper)other);
        }

        private boolean equalTo(UpWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "UpWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="pull")
    private static class PullWrapper
    implements Base {
        private final PullEvent value;

        @JsonCreator
        private PullWrapper(@JsonProperty(value="pull") PullEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"pull cannot be null");
            this.value = value;
        }

        @JsonProperty(value="pull")
        private PullEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PullWrapper && this.equalTo((PullWrapper)other);
        }

        private boolean equalTo(PullWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "PullWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeName(value="build")
    private static class BuildWrapper
    implements Base {
        private final BuildEvent value;

        @JsonCreator
        private BuildWrapper(@JsonProperty(value="build") BuildEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"build cannot be null");
            this.value = value;
        }

        @JsonProperty(value="build")
        private BuildEvent getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof BuildWrapper && this.equalTo((BuildWrapper)other);
        }

        private boolean equalTo(BuildWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "BuildWrapper" + '{' + "value" + ": " + this.value + '}';
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=BuildWrapper.class), @JsonSubTypes.Type(value=PullWrapper.class), @JsonSubTypes.Type(value=UpWrapper.class), @JsonSubTypes.Type(value=WaitForServicesWrapper.class), @JsonSubTypes.Type(value=ClusterWaitWrapper.class), @JsonSubTypes.Type(value=ShutdownStopWrapper.class), @JsonSubTypes.Type(value=LogCollectionWrapper.class), @JsonSubTypes.Type(value=ShutdownWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
    }

    public static interface CompletedStageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public CompletedStageVisitorBuilder<T> unknown(Function<String, T> var1);
    }

    public static interface WaitForServicesStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> waitForServices(Function<WaitForServicesEvent, T> var1);
    }

    public static interface UpStageVisitorBuilder<T> {
        public WaitForServicesStageVisitorBuilder<T> up(Function<UpEvent, T> var1);
    }

    public static interface ShutdownStopStageVisitorBuilder<T> {
        public UpStageVisitorBuilder<T> shutdownStop(Function<ShutdownStopEvent, T> var1);
    }

    public static interface ShutdownStageVisitorBuilder<T> {
        public ShutdownStopStageVisitorBuilder<T> shutdown(Function<ShutdownEvent, T> var1);
    }

    public static interface PullStageVisitorBuilder<T> {
        public ShutdownStageVisitorBuilder<T> pull(Function<PullEvent, T> var1);
    }

    public static interface LogCollectionStageVisitorBuilder<T> {
        public PullStageVisitorBuilder<T> logCollection(Function<LogCollectionEvent, T> var1);
    }

    public static interface ClusterWaitStageVisitorBuilder<T> {
        public LogCollectionStageVisitorBuilder<T> clusterWait(Function<ClusterWaitEvent, T> var1);
    }

    public static interface BuildStageVisitorBuilder<T> {
        public ClusterWaitStageVisitorBuilder<T> build(Function<BuildEvent, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements BuildStageVisitorBuilder<T>,
    ClusterWaitStageVisitorBuilder<T>,
    LogCollectionStageVisitorBuilder<T>,
    PullStageVisitorBuilder<T>,
    ShutdownStageVisitorBuilder<T>,
    ShutdownStopStageVisitorBuilder<T>,
    UpStageVisitorBuilder<T>,
    WaitForServicesStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    CompletedStageVisitorBuilder<T> {
        private Function<BuildEvent, T> buildVisitor;
        private Function<ClusterWaitEvent, T> clusterWaitVisitor;
        private Function<LogCollectionEvent, T> logCollectionVisitor;
        private Function<PullEvent, T> pullVisitor;
        private Function<ShutdownEvent, T> shutdownVisitor;
        private Function<ShutdownStopEvent, T> shutdownStopVisitor;
        private Function<UpEvent, T> upVisitor;
        private Function<WaitForServicesEvent, T> waitForServicesVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public ClusterWaitStageVisitorBuilder<T> build(Function<BuildEvent, T> buildVisitor) {
            Preconditions.checkNotNull(buildVisitor, (String)"buildVisitor cannot be null");
            this.buildVisitor = buildVisitor;
            return this;
        }

        @Override
        public LogCollectionStageVisitorBuilder<T> clusterWait(Function<ClusterWaitEvent, T> clusterWaitVisitor) {
            Preconditions.checkNotNull(clusterWaitVisitor, (String)"clusterWaitVisitor cannot be null");
            this.clusterWaitVisitor = clusterWaitVisitor;
            return this;
        }

        @Override
        public PullStageVisitorBuilder<T> logCollection(Function<LogCollectionEvent, T> logCollectionVisitor) {
            Preconditions.checkNotNull(logCollectionVisitor, (String)"logCollectionVisitor cannot be null");
            this.logCollectionVisitor = logCollectionVisitor;
            return this;
        }

        @Override
        public ShutdownStageVisitorBuilder<T> pull(Function<PullEvent, T> pullVisitor) {
            Preconditions.checkNotNull(pullVisitor, (String)"pullVisitor cannot be null");
            this.pullVisitor = pullVisitor;
            return this;
        }

        @Override
        public ShutdownStopStageVisitorBuilder<T> shutdown(Function<ShutdownEvent, T> shutdownVisitor) {
            Preconditions.checkNotNull(shutdownVisitor, (String)"shutdownVisitor cannot be null");
            this.shutdownVisitor = shutdownVisitor;
            return this;
        }

        @Override
        public UpStageVisitorBuilder<T> shutdownStop(Function<ShutdownStopEvent, T> shutdownStopVisitor) {
            Preconditions.checkNotNull(shutdownStopVisitor, (String)"shutdownStopVisitor cannot be null");
            this.shutdownStopVisitor = shutdownStopVisitor;
            return this;
        }

        @Override
        public WaitForServicesStageVisitorBuilder<T> up(Function<UpEvent, T> upVisitor) {
            Preconditions.checkNotNull(upVisitor, (String)"upVisitor cannot be null");
            this.upVisitor = upVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> waitForServices(Function<WaitForServicesEvent, T> waitForServicesVisitor) {
            Preconditions.checkNotNull(waitForServicesVisitor, (String)"waitForServicesVisitor cannot be null");
            this.waitForServicesVisitor = waitForServicesVisitor;
            return this;
        }

        @Override
        public CompletedStageVisitorBuilder<T> unknown(Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, (String)"unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<BuildEvent, T> buildVisitor = this.buildVisitor;
            final Function<ClusterWaitEvent, T> clusterWaitVisitor = this.clusterWaitVisitor;
            final Function<LogCollectionEvent, T> logCollectionVisitor = this.logCollectionVisitor;
            final Function<PullEvent, T> pullVisitor = this.pullVisitor;
            final Function<ShutdownEvent, T> shutdownVisitor = this.shutdownVisitor;
            final Function<ShutdownStopEvent, T> shutdownStopVisitor = this.shutdownStopVisitor;
            final Function<UpEvent, T> upVisitor = this.upVisitor;
            final Function<WaitForServicesEvent, T> waitForServicesVisitor = this.waitForServicesVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitBuild(BuildEvent value) {
                    return buildVisitor.apply(value);
                }

                @Override
                public T visitClusterWait(ClusterWaitEvent value) {
                    return clusterWaitVisitor.apply(value);
                }

                @Override
                public T visitLogCollection(LogCollectionEvent value) {
                    return logCollectionVisitor.apply(value);
                }

                @Override
                public T visitPull(PullEvent value) {
                    return pullVisitor.apply(value);
                }

                @Override
                public T visitShutdown(ShutdownEvent value) {
                    return shutdownVisitor.apply(value);
                }

                @Override
                public T visitShutdownStop(ShutdownStopEvent value) {
                    return shutdownStopVisitor.apply(value);
                }

                @Override
                public T visitUp(UpEvent value) {
                    return upVisitor.apply(value);
                }

                @Override
                public T visitWaitForServices(WaitForServicesEvent value) {
                    return waitForServicesVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitBuild(BuildEvent var1);

        public T visitPull(PullEvent var1);

        public T visitUp(UpEvent var1);

        public T visitWaitForServices(WaitForServicesEvent var1);

        public T visitClusterWait(ClusterWaitEvent var1);

        public T visitShutdownStop(ShutdownStopEvent var1);

        public T visitLogCollection(LogCollectionEvent var1);

        public T visitShutdown(ShutdownEvent var1);

        public T visitUnknown(String var1);

        public static <T> BuildStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

