/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.codahale.metrics.Gauge;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;

final class DialogueClientPoolMetrics {
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = Optional.ofNullable(DialogueClientPoolMetrics.class.getPackage().getImplementationVersion()).orElse("unknown");
    private final TaggedMetricRegistry registry;

    private DialogueClientPoolMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static DialogueClientPoolMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientPoolMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    SizeBuilderClientNameStage size() {
        return new SizeBuilder();
    }

    public String toString() {
        return "DialogueClientPoolMetrics{registry=" + this.registry + '}';
    }

    private final class SizeBuilder
    implements SizeBuilderClientNameStage,
    SizeBuilderStateStage,
    SizeBuildStage {
        private String clientName;
        private String state;

        private SizeBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            DialogueClientPoolMetrics.this.registry.registerWithReplacement(MetricName.builder().safeName("dialogue.client.pool.size").putSafeTags("client-name", this.clientName).putSafeTags("state", this.state).putSafeTags("libraryName", DialogueClientPoolMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build(), gauge);
        }

        @Override
        public SizeBuilder clientName(String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public SizeBuilder state(String state) {
            Preconditions.checkState((this.state == null ? 1 : 0) != 0, (String)"state is already set");
            this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state is required");
            return this;
        }
    }

    static interface SizeBuilderStateStage {
        public SizeBuildStage state(String var1);
    }

    static interface SizeBuilderClientNameStage {
        public SizeBuilderStateStage clientName(String var1);
    }

    static interface SizeBuildStage {
        public void build(Gauge<?> var1);
    }
}

