/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.codahale.metrics.Meter;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.palantir.conjure.java.api.config.service.BasicCredentials;
import com.palantir.conjure.java.client.config.CipherSuites;
import com.palantir.conjure.java.client.config.ClientConfiguration;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.blocking.BlockingChannel;
import com.palantir.dialogue.blocking.BlockingChannelAdapter;
import com.palantir.dialogue.core.DialogueChannel;
import com.palantir.dialogue.core.DialogueInternalWeakReducingGauge;
import com.palantir.dialogue.hc4.ApacheHttpClientBlockingChannel;
import com.palantir.dialogue.hc4.DialogueClientMetrics;
import com.palantir.dialogue.hc4.ResponseLeakDetector;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.tritium.metrics.MetricRegistries;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpClientChannels {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClientChannels.class);

    private ApacheHttpClientChannels() {
    }

    public static Channel create(ClientConfiguration conf) {
        String channelName = "apache-channel";
        CloseableClient client = ApacheHttpClientChannels.createCloseableHttpClient(conf, channelName);
        return DialogueChannel.builder().channelName(channelName).clientConfiguration(conf).channelFactory(uri -> ApacheHttpClientChannels.createSingleUri(uri, client)).build();
    }

    public static Channel createSingleUri(String uri, CloseableClient client) {
        ApacheHttpClientBlockingChannel blockingChannel = new ApacheHttpClientBlockingChannel(client, ApacheHttpClientChannels.url(uri), client.leakDetector);
        return client.executor == null ? BlockingChannelAdapter.of((BlockingChannel)blockingChannel) : BlockingChannelAdapter.of((BlockingChannel)blockingChannel, (ExecutorService)client.executor);
    }

    @Deprecated
    public static CloseableClient createCloseableHttpClient(ClientConfiguration conf) {
        return ApacheHttpClientChannels.createCloseableHttpClient(conf, "apache-channel");
    }

    public static CloseableClient createCloseableHttpClient(ClientConfiguration conf, String clientName) {
        return ApacheHttpClientChannels.clientBuilder().clientConfiguration(conf).clientName(clientName).build();
    }

    private static void setupConnectionPoolMetrics(TaggedMetricRegistry taggedMetrics, String clientName, PoolingHttpClientConnectionManager connectionManager) {
        DialogueInternalWeakReducingGauge.getOrCreate((TaggedMetricRegistry)taggedMetrics, (MetricName)ApacheHttpClientChannels.clientPoolSizeMetricName(clientName, "idle"), pool -> pool.getTotalStats().getAvailable(), LongStream::sum, (Object)connectionManager);
        DialogueInternalWeakReducingGauge.getOrCreate((TaggedMetricRegistry)taggedMetrics, (MetricName)ApacheHttpClientChannels.clientPoolSizeMetricName(clientName, "leased"), pool -> pool.getTotalStats().getLeased(), LongStream::sum, (Object)connectionManager);
        DialogueInternalWeakReducingGauge.getOrCreate((TaggedMetricRegistry)taggedMetrics, (MetricName)ApacheHttpClientChannels.clientPoolSizeMetricName(clientName, "pending"), pool -> pool.getTotalStats().getPending(), LongStream::sum, (Object)connectionManager);
    }

    private static MetricName clientPoolSizeMetricName(String clientName, String state) {
        return MetricName.builder().safeName("dialogue.client.pool.size").putSafeTags("client-name", clientName).putSafeTags("state", state).build();
    }

    public static ClientBuilder clientBuilder() {
        return new ClientBuilder();
    }

    private static ThreadFactory idleConnectionEvictorThreadFactory(String clientName, TaggedMetricRegistry metrics) {
        Preconditions.checkNotNull((Object)clientName, (String)"Client name is required");
        Preconditions.checkNotNull((Object)metrics, (String)"TaggedMetricRegistry is required");
        return MetricRegistries.instrument((TaggedMetricRegistry)metrics, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat(clientName + "-IdleConnectionEvictor-%d").setDaemon(true).build(), (String)"DialogueIdleConnectionEvictor");
    }

    private static String[] supportedCipherSuites(String[] cipherSuites, SSLSocketFactory socketFactory, String clientName) {
        ImmutableSet<String> jvmSupported = ApacheHttpClientChannels.supportedCipherSuites(socketFactory);
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> unsupported = new ArrayList<String>();
        for (String cipherSuite : cipherSuites) {
            if (jvmSupported.contains(cipherSuite)) {
                enabled.add(cipherSuite);
                continue;
            }
            unsupported.add(cipherSuite);
        }
        if (!unsupported.isEmpty()) {
            log.debug("Skipping unsupported cipher suites", new Object[]{SafeArg.of((String)"client", (Object)clientName), SafeArg.of((String)"numEnabled", (Object)enabled.size()), SafeArg.of((String)"numUnsupported", (Object)unsupported.size()), SafeArg.of((String)"cipher", unsupported), SafeArg.of((String)"javaVendor", (Object)System.getProperty("java.vendor")), SafeArg.of((String)"javaVersion", (Object)System.getProperty("java.version"))});
        }
        Preconditions.checkState((!enabled.isEmpty() ? 1 : 0) != 0, (String)"Zero supported cipher suites");
        return enabled.toArray(new String[0]);
    }

    private static ImmutableSet<String> supportedCipherSuites(SSLSocketFactory socketFactory) {
        return ImmutableSet.copyOf((Object[])socketFactory.getSupportedCipherSuites());
    }

    private static URL url(String uri) {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new SafeIllegalArgumentException("Failed to parse URL", (Throwable)e, new Arg[0]);
        }
    }

    private static enum NullAuthenticationStrategy implements AuthenticationStrategy
    {
        INSTANCE;


        public boolean isAuthenticationRequested(HttpHost _authhost, HttpResponse _response, HttpContext _context) {
            return false;
        }

        public Map<String, Header> getChallenges(HttpHost _authhost, HttpResponse _response, HttpContext _context) {
            return Collections.emptyMap();
        }

        public Queue<AuthOption> select(Map<String, Header> _challenges, HttpHost _authhost, HttpResponse _response, HttpContext _context) {
            return new ArrayDeque<AuthOption>(1);
        }

        public void authSucceeded(HttpHost _authhost, AuthScheme _authScheme, HttpContext _context) {
        }

        public void authFailed(HttpHost _authhost, AuthScheme _authScheme, HttpContext _context) {
        }
    }

    private static final class SingleCredentialsProvider
    implements CredentialsProvider {
        private final Credentials credentials;

        SingleCredentialsProvider(BasicCredentials basicCredentials) {
            this.credentials = new UsernamePasswordCredentials(basicCredentials.username(), basicCredentials.password());
        }

        public void setCredentials(AuthScope _authscope, Credentials _credentials) {
        }

        public Credentials getCredentials(AuthScope _authscope) {
            return this.credentials;
        }

        public void clear() {
        }
    }

    private static enum NullCredentialsProvider implements CredentialsProvider
    {
        INSTANCE;


        public void setCredentials(AuthScope _authscope, Credentials _credentials) {
        }

        @Nullable
        public Credentials getCredentials(AuthScope _authscope) {
            return null;
        }

        public void clear() {
        }
    }

    public static final class ClientBuilder {
        private static final long DEFAULT_IDLE_CONNECTION_TIMEOUT_MILLIS = 50000L;
        @Nullable
        private ClientConfiguration clientConfiguration;
        @Nullable
        private String clientName;
        @Nullable
        private ExecutorService executor;

        private ClientBuilder() {
        }

        public ClientBuilder clientConfiguration(ClientConfiguration value) {
            this.clientConfiguration = (ClientConfiguration)Preconditions.checkNotNull((Object)value, (String)"ClientConfiguration is required");
            return this;
        }

        public ClientBuilder clientName(@Safe String value) {
            this.clientName = (String)Preconditions.checkNotNull((Object)value, (String)"clientName is required");
            return this;
        }

        public ClientBuilder executor(ExecutorService value) {
            this.executor = (ExecutorService)Preconditions.checkNotNull((Object)value, (String)"ExecutorService is required");
            return this;
        }

        public CloseableClient build() {
            ClientConfiguration conf = (ClientConfiguration)Preconditions.checkNotNull((Object)this.clientConfiguration, (String)"ClientConfiguration is required");
            String name = (String)Preconditions.checkNotNull((Object)this.clientName, (String)"Client name is required");
            Preconditions.checkArgument((!conf.fallbackToCommonNameVerification() ? 1 : 0) != 0, (String)"fallback-to-common-name-verification is not supported");
            Preconditions.checkArgument((!conf.meshProxy().isPresent() ? 1 : 0) != 0, (String)"Mesh proxy is not supported");
            long socketTimeoutMillis = conf.readTimeout().toMillis();
            if (conf.readTimeout().toMillis() != conf.writeTimeout().toMillis()) {
                log.warn("Read and write timeouts do not match, The value of the readTimeout {} will be used and write timeout {} will be ignored.", (Object)SafeArg.of((String)"readTimeout", (Object)conf.readTimeout()), (Object)SafeArg.of((String)"writeTimeout", (Object)conf.writeTimeout()));
            }
            int connectTimeout = Ints.checkedCast((long)conf.connectTimeout().toMillis());
            long idleConnectionTimeoutMillis = socketTimeoutMillis > 0L ? Math.min(50000L, socketTimeoutMillis) : 50000L;
            int connectionPoolInactivityCheckMillis = (int)((double)idleConnectionTimeoutMillis / 2.5);
            SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).build();
            SSLSocketFactory rawSocketFactory = conf.sslSocketFactory();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(MetricRegistries.instrument((TaggedMetricRegistry)conf.taggedMetricRegistry(), (SSLSocketFactory)rawSocketFactory, (String)name), new String[]{"TLSv1.2"}, ApacheHttpClientChannels.supportedCipherSuites(conf.enableGcmCipherSuites() ? CipherSuites.allCipherSuites() : CipherSuites.fastCipherSuites(), rawSocketFactory, name), (HostnameVerifier)new DefaultHostnameVerifier());
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build());
            ApacheHttpClientChannels.setupConnectionPoolMetrics(conf.taggedMetricRegistry(), name, connectionManager);
            connectionManager.setDefaultSocketConfig(socketConfig);
            connectionManager.setMaxTotal(Integer.MAX_VALUE);
            connectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
            connectionManager.setValidateAfterInactivity(connectionPoolInactivityCheckMillis);
            HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(Ints.checkedCast((long)socketTimeoutMillis)).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setRedirectsEnabled(false).setRelativeRedirectsAllowed(false).setNormalizeUri(false).build()).setConnectionManagerShared(true).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(null, conf.proxy())).disableAutomaticRetries().disableConnectionState().disableCookieManagement().disableContentCompression().setDefaultCredentialsProvider((CredentialsProvider)NullCredentialsProvider.INSTANCE).setTargetAuthenticationStrategy((AuthenticationStrategy)NullAuthenticationStrategy.INSTANCE).setProxyAuthenticationStrategy((AuthenticationStrategy)NullAuthenticationStrategy.INSTANCE).setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().build());
            conf.proxyCredentials().ifPresent(credentials -> builder.setDefaultCredentialsProvider((CredentialsProvider)new SingleCredentialsProvider((BasicCredentials)credentials)).setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).build()));
            CloseableHttpClient apacheClient = builder.build();
            IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor((HttpClientConnectionManager)connectionManager, ApacheHttpClientChannels.idleConnectionEvictorThreadFactory(name, conf.taggedMetricRegistry()), Math.min(idleConnectionTimeoutMillis, 5000L), TimeUnit.MILLISECONDS, idleConnectionTimeoutMillis, TimeUnit.MILLISECONDS);
            return CloseableClient.wrap(apacheClient, name, connectionManager, connectionEvictor, conf, this.executor);
        }
    }

    public static final class CloseableClient
    implements Closeable {
        private static final String APACHE = "apache";
        private final String clientName;
        private final CloseableHttpClient apacheClient;
        private final PoolingHttpClientConnectionManager pool;
        private final ResponseLeakDetector leakDetector;
        @Nullable
        private final ExecutorService executor;
        private final Closer closer = Closer.create();

        private CloseableClient(CloseableHttpClient apacheClient, @Safe String clientName, PoolingHttpClientConnectionManager pool, IdleConnectionEvictor connectionEvictor, TaggedMetricRegistry taggedMetrics, ResponseLeakDetector leakDetector, @Nullable ExecutorService executor) {
            this.clientName = clientName;
            this.apacheClient = apacheClient;
            this.pool = pool;
            this.leakDetector = leakDetector;
            this.executor = executor;
            this.closer.register(() -> {
                connectionEvictor.shutdown();
                try {
                    connectionEvictor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            });
            connectionEvictor.start();
            this.closer.register((Closeable)apacheClient);
            this.closer.register(() -> ((PoolingHttpClientConnectionManager)pool).shutdown());
            this.closer.register(() -> ((Meter)DialogueClientMetrics.of(taggedMetrics).close().clientName(clientName).clientType(APACHE).build()).mark());
        }

        static CloseableClient wrap(CloseableHttpClient apacheClient, @Safe String clientName, PoolingHttpClientConnectionManager pool, IdleConnectionEvictor connectionEvictor, ClientConfiguration clientConfiguration, @Nullable ExecutorService executor) {
            ResponseLeakDetector leakDetector = ResponseLeakDetector.of(clientName, clientConfiguration.taggedMetricRegistry());
            CloseableClient newInstance = new CloseableClient(apacheClient, clientName, pool, connectionEvictor, clientConfiguration.taggedMetricRegistry(), leakDetector, executor);
            log.info("Created Apache client {} {} {} {}", new Object[]{SafeArg.of((String)"name", (Object)clientName), SafeArg.of((String)"client", (Object)Integer.toHexString(System.identityHashCode(apacheClient))), UnsafeArg.of((String)"clientConfiguration", (Object)clientConfiguration), UnsafeArg.of((String)"executor", (Object)executor)});
            Meter createMeter = DialogueClientMetrics.of(clientConfiguration.taggedMetricRegistry()).create().clientName(clientName).clientType(APACHE).build();
            createMeter.mark();
            return newInstance;
        }

        CloseableHttpClient apacheClient() {
            return this.apacheClient;
        }

        @Override
        public void close() throws IOException {
            if (log.isDebugEnabled()) {
                PoolStats poolStats = this.pool.getTotalStats();
                log.debug("ApacheHttpClientChannels#close - {} {} {} {} {}", new Object[]{SafeArg.of((String)"name", (Object)this.clientName), SafeArg.of((String)"client", (Object)Integer.toHexString(System.identityHashCode(this.apacheClient))), SafeArg.of((String)"idle", (Object)poolStats.getAvailable()), SafeArg.of((String)"leased", (Object)poolStats.getLeased()), SafeArg.of((String)"pending", (Object)poolStats.getPending()), new SafeRuntimeException("Exception for stacktrace", new Arg[0])});
            }
            this.pool.closeIdleConnections(0L, TimeUnit.NANOSECONDS);
        }

        protected void finalize() throws Throwable {
            try {
                this.finalizeApacheClient();
            }
            finally {
                super.finalize();
            }
        }

        private void finalizeApacheClient() throws IOException {
            if (log.isInfoEnabled()) {
                PoolStats poolStats = this.pool.getTotalStats();
                log.info("ApacheHttpClientChannels#finalize - {} {} {} {} {}", new Object[]{SafeArg.of((String)"name", (Object)this.clientName), SafeArg.of((String)"client", (Object)Integer.toHexString(System.identityHashCode(this.apacheClient))), SafeArg.of((String)"idle", (Object)poolStats.getAvailable()), SafeArg.of((String)"leased", (Object)poolStats.getLeased()), SafeArg.of((String)"pending", (Object)poolStats.getPending())});
            }
            this.closer.close();
        }

        public String toString() {
            return "CloseableClient@" + Integer.toHexString(System.identityHashCode(this)) + "{clientName='" + this.clientName + '\'' + ", client=" + this.apacheClient + ", pool=" + this.pool + ", leakDetector=" + this.leakDetector + ", executor=" + this.executor + '}';
        }
    }
}

