/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.codahale.metrics.Meter;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueClientMetrics {
    private final TaggedMetricRegistry registry;

    private DialogueClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static DialogueClientMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    ResponseLeakBuilderClientNameStage responseLeak() {
        return new ResponseLeakBuilder();
    }

    CreateBuilderClientNameStage create() {
        return new CreateBuilder();
    }

    CloseBuilderClientNameStage close() {
        return new CloseBuilder();
    }

    public String toString() {
        return "DialogueClientMetrics{registry=" + this.registry + '}';
    }

    private final class CloseBuilder
    implements CloseBuilderClientNameStage,
    CloseBuilderClientTypeStage,
    CloseBuildStage {
        private String clientName;
        private String clientType;

        private CloseBuilder() {
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(MetricName.builder().safeName("dialogue.client.close").putSafeTags("client-name", this.clientName).putSafeTags("client-type", this.clientType).build());
        }

        @Override
        public CloseBuilder clientName(String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public CloseBuilder clientType(String clientType) {
            Preconditions.checkState((this.clientType == null ? 1 : 0) != 0, (String)"client-type is already set");
            this.clientType = (String)Preconditions.checkNotNull((Object)clientType, (String)"client-type is required");
            return this;
        }
    }

    static interface CloseBuilderClientTypeStage {
        public CloseBuildStage clientType(String var1);
    }

    static interface CloseBuilderClientNameStage {
        public CloseBuilderClientTypeStage clientName(String var1);
    }

    static interface CloseBuildStage {
        public Meter build();
    }

    private final class CreateBuilder
    implements CreateBuilderClientNameStage,
    CreateBuilderClientTypeStage,
    CreateBuildStage {
        private String clientName;
        private String clientType;

        private CreateBuilder() {
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(MetricName.builder().safeName("dialogue.client.create").putSafeTags("client-name", this.clientName).putSafeTags("client-type", this.clientType).build());
        }

        @Override
        public CreateBuilder clientName(String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public CreateBuilder clientType(String clientType) {
            Preconditions.checkState((this.clientType == null ? 1 : 0) != 0, (String)"client-type is already set");
            this.clientType = (String)Preconditions.checkNotNull((Object)clientType, (String)"client-type is required");
            return this;
        }
    }

    static interface CreateBuilderClientTypeStage {
        public CreateBuildStage clientType(String var1);
    }

    static interface CreateBuilderClientNameStage {
        public CreateBuilderClientTypeStage clientName(String var1);
    }

    static interface CreateBuildStage {
        public Meter build();
    }

    private final class ResponseLeakBuilder
    implements ResponseLeakBuilderClientNameStage,
    ResponseLeakBuilderServiceNameStage,
    ResponseLeakBuilderEndpointStage,
    ResponseLeakBuildStage {
        private String clientName;
        private String serviceName;
        private String endpoint;

        private ResponseLeakBuilder() {
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(MetricName.builder().safeName("dialogue.client.response.leak").putSafeTags("client-name", this.clientName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).build());
        }

        @Override
        public ResponseLeakBuilder clientName(String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder serviceName(String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder endpoint(String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }
    }

    static interface ResponseLeakBuilderEndpointStage {
        public ResponseLeakBuildStage endpoint(String var1);
    }

    static interface ResponseLeakBuilderServiceNameStage {
        public ResponseLeakBuilderEndpointStage serviceName(String var1);
    }

    static interface ResponseLeakBuilderClientNameStage {
        public ResponseLeakBuilderServiceNameStage clientName(String var1);
    }

    static interface ResponseLeakBuildStage {
        public Meter build();
    }
}

