/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.codahale.metrics.Gauge;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.ToIntFunction;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class WeakSummingGauge<T>
implements Gauge<Integer> {
    private final ToIntFunction<T> gaugeFunction;
    @GuardedBy(value="this")
    private final Set<T> weakSet = Collections.newSetFromMap(new WeakHashMap(2));

    WeakSummingGauge(ToIntFunction<T> gaugeFunction) {
        this.gaugeFunction = gaugeFunction;
    }

    public synchronized void add(T sourceElement) {
        this.weakSet.add(sourceElement);
    }

    public synchronized Integer getValue() {
        return this.weakSet.stream().mapToInt(this.gaugeFunction).sum();
    }

    public static <T> WeakSummingGauge<T> getOrCreate(ToIntFunction<T> toIntFunction, T initialValue, TaggedMetricRegistry taggedMetricRegistry, MetricName metricName) {
        WeakSummingGauge gauge = (WeakSummingGauge)taggedMetricRegistry.gauge(metricName, new WeakSummingGauge<T>(toIntFunction));
        gauge.add(initialValue);
        return gauge;
    }
}

