/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.codahale.metrics.Meter;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueClientMetrics {
    private final TaggedMetricRegistry registry;

    private DialogueClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static DialogueClientMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    ResponseLeakBuilderClientNameStage responseLeak() {
        return new ResponseLeakBuilder();
    }

    public String toString() {
        return "DialogueClientMetrics{registry=" + this.registry + '}';
    }

    private final class ResponseLeakBuilder
    implements ResponseLeakBuilderClientNameStage,
    ResponseLeakBuilderServiceNameStage,
    ResponseLeakBuilderEndpointStage,
    ResponseLeakBuildStage {
        private String clientName;
        private String serviceName;
        private String endpoint;

        private ResponseLeakBuilder() {
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(MetricName.builder().safeName("dialogue.client.response.leak").putSafeTags("client-name", this.clientName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).build());
        }

        @Override
        public ResponseLeakBuilder clientName(String clientName) {
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder serviceName(String serviceName) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder endpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }
    }

    static interface ResponseLeakBuilderEndpointStage {
        public ResponseLeakBuildStage endpoint(String var1);
    }

    static interface ResponseLeakBuilderServiceNameStage {
        public ResponseLeakBuilderEndpointStage serviceName(String var1);
    }

    static interface ResponseLeakBuilderClientNameStage {
        public ResponseLeakBuilderServiceNameStage clientName(String var1);
    }

    static interface ResponseLeakBuildStage {
        public Meter build();
    }
}

