/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.HttpMethod;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.blocking.BlockingChannel;
import com.palantir.dialogue.core.BaseUrl;
import com.palantir.dialogue.hc4.ResponseLeakDetector;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApacheHttpClientBlockingChannel
implements BlockingChannel {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClientBlockingChannel.class);
    private final CloseableHttpClient client;
    private final BaseUrl baseUrl;
    private final ResponseLeakDetector responseLeakDetector;

    ApacheHttpClientBlockingChannel(CloseableHttpClient client, URL baseUrl, ResponseLeakDetector responseLeakDetector) {
        this.client = client;
        this.baseUrl = BaseUrl.of((URL)baseUrl);
        this.responseLeakDetector = responseLeakDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Endpoint endpoint, Request request) throws IOException {
        URL target = this.baseUrl.render(endpoint, request);
        RequestBuilder builder = RequestBuilder.create((String)endpoint.httpMethod().name()).setUri(target.toString());
        request.headerParams().forEach((arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
        if (request.body().isPresent()) {
            Preconditions.checkArgument((endpoint.httpMethod() != HttpMethod.GET ? 1 : 0) != 0, (String)"GET endpoints must not have a request body");
            RequestBody body = (RequestBody)request.body().get();
            builder.setEntity((HttpEntity)new RequestBodyEntity(body));
        }
        CloseableHttpResponse httpClientResponse = this.client.execute(builder.build());
        boolean close = true;
        try {
            HttpClientResponse dialogueResponse = new HttpClientResponse(httpClientResponse);
            Response leakDetectingResponse = this.responseLeakDetector.wrap(dialogueResponse, endpoint);
            close = false;
            Response response = leakDetectingResponse;
            return response;
        }
        finally {
            if (close) {
                httpClientResponse.close();
            }
        }
    }

    private static final class RequestBodyEntity
    implements HttpEntity {
        private final RequestBody requestBody;
        private final Header contentType;

        RequestBodyEntity(RequestBody requestBody) {
            this.requestBody = requestBody;
            this.contentType = new BasicHeader("Content-Type", requestBody.contentType());
        }

        public boolean isRepeatable() {
            return this.requestBody.repeatable();
        }

        public boolean isChunked() {
            return true;
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return this.contentType;
        }

        @Nullable
        public Header getContentEncoding() {
            return null;
        }

        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("getContent is not supported, writeTo should be used");
        }

        public void writeTo(OutputStream outStream) throws IOException {
            this.requestBody.writeTo(outStream);
        }

        public boolean isStreaming() {
            return false;
        }

        public void consumeContent() {
        }

        public String toString() {
            return "RequestBodyEntity{requestBody=" + this.requestBody + '}';
        }
    }

    private static final class HttpClientResponse
    implements Response {
        private final CloseableHttpResponse response;
        @Nullable
        private ListMultimap<String, String> headers;

        HttpClientResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        public InputStream body() {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException e) {
                throw new SafeRuntimeException("Failed to get response stream", (Throwable)e, new Arg[0]);
            }
        }

        public int code() {
            return this.response.getStatusLine().getStatusCode();
        }

        public ListMultimap<String, String> headers() {
            if (this.headers == null) {
                ListMultimap tmpHeaders = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).arrayListValues().build();
                HeaderIterator headerIterator = this.response.headerIterator();
                while (headerIterator.hasNext()) {
                    Header header = headerIterator.nextHeader();
                    String value = header.getValue();
                    if (value == null) continue;
                    tmpHeaders.put((Object)header.getName(), (Object)value);
                }
                this.headers = tmpHeaders;
            }
            return this.headers;
        }

        public Optional<String> getFirstHeader(String header) {
            return Optional.ofNullable(this.response.getFirstHeader(header)).map(NameValuePair::getValue);
        }

        public void close() {
            try {
                this.response.close();
            }
            catch (IOException | RuntimeException e) {
                log.warn("Failed to close response", (Throwable)e);
            }
        }

        public String toString() {
            return "HttpClientResponse{response=" + this.response + '}';
        }
    }
}

