/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

final class SafeLoggingHttpClientConnectionManager
implements HttpClientConnectionManager,
Closeable {
    private final HttpClientConnectionManager delegate;
    private volatile boolean closed = false;

    SafeLoggingHttpClientConnectionManager(HttpClientConnectionManager delegate) {
        this.delegate = (HttpClientConnectionManager)Preconditions.checkNotNull((Object)delegate, (String)"HttpClientConnectionManager is required");
    }

    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        try {
            return this.delegate.requestConnection(route, state);
        }
        catch (IllegalStateException e) {
            if (this.closed) {
                throw new SafeIllegalStateException("Connection pool shut down", (Throwable)e, new Arg[0]);
            }
            throw e;
        }
    }

    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        this.delegate.releaseConnection(conn, newState, validDuration, timeUnit);
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        this.delegate.connect(conn, route, connectTimeout, context);
    }

    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.delegate.upgrade(conn, route, context);
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.delegate.routeComplete(conn, route, context);
    }

    public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
        this.delegate.closeIdleConnections(idletime, timeUnit);
    }

    public void closeExpiredConnections() {
        this.delegate.closeExpiredConnections();
    }

    public void shutdown() {
        this.closed = true;
        this.delegate.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.delegate instanceof Closeable) {
            ((Closeable)this.delegate).close();
        } else {
            this.delegate.shutdown();
        }
    }

    public String toString() {
        return "SafeLoggingHttpClientConnectionManager{delegate=" + this.delegate + ", closed=" + this.closed + '}';
    }
}

