/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.hc4;

import com.google.common.collect.ListMultimap;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.hc4.DialogueClientMetrics;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.random.SafeThreadLocalRandom;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseLeakDetector {
    private static final Logger log = LoggerFactory.getLogger(ResponseLeakDetector.class);
    private final String clientName;
    private final DialogueClientMetrics metrics;
    private final Random random;
    private final float leakDetectionProbability;

    public static ResponseLeakDetector of(String clientName, TaggedMetricRegistry metrics) {
        return new ResponseLeakDetector(clientName, DialogueClientMetrics.of(metrics), SafeThreadLocalRandom.get(), 0.01f);
    }

    ResponseLeakDetector(String clientName, DialogueClientMetrics metrics, Random random, float leakDetectionProbability) {
        this.clientName = clientName;
        this.metrics = metrics;
        this.random = random;
        this.leakDetectionProbability = leakDetectionProbability;
    }

    public Response wrap(Response input, Endpoint endpoint) {
        if (this.shouldApplyLeakDetection()) {
            return new LeakDetectingResponse(input, new LeakDetector(input, endpoint));
        }
        return input;
    }

    private boolean shouldApplyLeakDetection() {
        if (this.leakDetectionProbability >= 1.0f) {
            return true;
        }
        if (this.leakDetectionProbability <= 0.0f) {
            return false;
        }
        return this.random.nextFloat() <= this.leakDetectionProbability;
    }

    public String toString() {
        return "ResponseLeakDetector{clientName='" + this.clientName + "', leakDetectionProbability=" + this.leakDetectionProbability + '}';
    }

    private static final class LeakDetectingResponse
    implements Response {
        private final Response delegate;
        private final LeakDetector leakDetector;
        @Nullable
        private InputStream leakDetectingStream;

        LeakDetectingResponse(Response delegate, LeakDetector leakDetector) {
            this.delegate = delegate;
            this.leakDetector = leakDetector;
        }

        public InputStream body() {
            if (this.leakDetectingStream == null) {
                this.leakDetectingStream = new LeakDetectingInputStream(this.delegate.body(), this.leakDetector);
            }
            return this.leakDetectingStream;
        }

        public int code() {
            return this.delegate.code();
        }

        public ListMultimap<String, String> headers() {
            return this.delegate.headers();
        }

        public Optional<String> getFirstHeader(String header) {
            return this.delegate.getFirstHeader(header);
        }

        public void close() {
            this.leakDetector.disarm();
            this.delegate.close();
        }

        public String toString() {
            return "LeakDetectingResponse{delegate=" + this.delegate + ", leakDetector=" + this.leakDetector + '}';
        }
    }

    private static final class LeakDetectingInputStream
    extends FilterInputStream {
        private final LeakDetector leakDetector;

        LeakDetectingInputStream(InputStream delegate, LeakDetector leakDetector) {
            super(delegate);
            this.leakDetector = leakDetector;
        }

        @Override
        public void close() throws IOException {
            this.leakDetector.disarm();
            super.close();
        }

        public String toString() {
            return "LeakDetectingInputStream{leakDetector=" + this.leakDetector + ", in=" + this.in + '}';
        }
    }

    private final class LeakDetector {
        private final Endpoint endpoint;
        private final Response response;
        @Nullable
        private final Throwable creationTrace;
        private boolean armed = true;

        LeakDetector(Response response, Endpoint endpoint) {
            this.response = response;
            this.endpoint = endpoint;
            this.creationTrace = log.isTraceEnabled() ? new SafeRuntimeException("created here", new Arg[0]) : null;
        }

        void disarm() {
            this.armed = false;
        }

        protected void finalize() throws Throwable {
            if (this.armed) {
                ResponseLeakDetector.this.metrics.responseLeak().clientName(ResponseLeakDetector.this.clientName).serviceName(this.endpoint.serviceName()).endpoint(this.endpoint.endpointName()).build().mark();
                if (this.creationTrace == null) {
                    log.warn("Detected a leaked response from service {} endpoint {} on channel {}. Enable trace logging to record stack traces.", new Object[]{SafeArg.of((String)"service", (Object)this.endpoint.serviceName()), SafeArg.of((String)"endpoint", (Object)this.endpoint.endpointName()), SafeArg.of((String)"client", (Object)ResponseLeakDetector.this.clientName)});
                } else {
                    log.warn("Detected a leaked response from service {} endpoint {} on channel {}", new Object[]{SafeArg.of((String)"service", (Object)this.endpoint.serviceName()), SafeArg.of((String)"endpoint", (Object)this.endpoint.endpointName()), SafeArg.of((String)"client", (Object)ResponseLeakDetector.this.clientName), this.creationTrace});
                }
                this.response.close();
            }
            super.finalize();
        }

        public String toString() {
            return "LeakDetector{endpoint=" + this.endpoint + ", response=" + this.response + ", armed=" + this.armed + '}';
        }
    }
}

