/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

final class JavaInstallationMetadataProxy
implements InvocationHandler {
    private final JavaLanguageVersion javaLanguageVersion;
    private final Provider<JavaInstallationMetadata> delegate;

    private JavaInstallationMetadataProxy(JavaLanguageVersion javaLanguageVersion, Provider<JavaInstallationMetadata> delegate) {
        this.javaLanguageVersion = javaLanguageVersion;
        this.delegate = delegate;
    }

    static JavaInstallationMetadata proxyForVersion(JavaLanguageVersion javaLanguageVersion, Provider<JavaInstallationMetadata> delegate) {
        return (JavaInstallationMetadata)Proxy.newProxyInstance(JavaInstallationMetadata.class.getClassLoader(), new Class[]{JavaInstallationMetadata.class}, (InvocationHandler)new JavaInstallationMetadataProxy(javaLanguageVersion, delegate));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if ("getLanguageVersion".equals(method.getName())) {
                return this.javaLanguageVersion;
            }
            return method.invoke(this.delegate.get(), args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

