/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import java.io.Serializable;
import java.util.Objects;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public final class ChosenJavaVersion
implements Serializable {
    private final JavaLanguageVersion javaLanguageVersion;
    private final boolean enablePreview;

    public ChosenJavaVersion(JavaLanguageVersion javaLanguageVersion, boolean enablePreview) {
        this.javaLanguageVersion = javaLanguageVersion;
        this.enablePreview = enablePreview;
    }

    public static ChosenJavaVersion fromString(String string) {
        return new ChosenJavaVersion(JavaLanguageVersion.of((String)string.replaceAll("_PREVIEW", "")), string.endsWith("_PREVIEW"));
    }

    public static ChosenJavaVersion of(int number) {
        return new ChosenJavaVersion(JavaLanguageVersion.of((int)number), false);
    }

    public static ChosenJavaVersion of(JavaLanguageVersion version) {
        return new ChosenJavaVersion(version, false);
    }

    public JavaLanguageVersion javaLanguageVersion() {
        return this.javaLanguageVersion;
    }

    public boolean enablePreview() {
        return this.enablePreview;
    }

    public String asIdeaLanguageLevel() {
        return "JDK_" + this.javaLanguageVersion.toString() + (this.enablePreview ? "_PREVIEW" : "");
    }

    public int asBytecodeMajorVersion() {
        return this.javaLanguageVersion.asInt() + 44;
    }

    public String toString() {
        return this.javaLanguageVersion.toString() + (this.enablePreview ? "_PREVIEW" : "");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChosenJavaVersion that = (ChosenJavaVersion)other;
        return this.enablePreview == that.enablePreview && this.javaLanguageVersion.equals(that.javaLanguageVersion);
    }

    public int hashCode() {
        return Objects.hash(this.javaLanguageVersion, this.enablePreview);
    }
}

