/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public abstract class CheckClasspathCompatible
extends DefaultTask {
    private static final int BYTECODE_IDENTIFIER = -889275714;

    @Console
    public abstract Property<String> getClasspathName();

    @Input
    public abstract Property<ChosenJavaVersion> getJavaVersion();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @TaskAction
    public final void action() {
        String exampleBadClassesPerJar = this.getClasspath().getFiles().stream().filter(file -> file.getName().endsWith(".jar")).flatMap(file -> this.tooHighBytecodeMajorVersionInJar((File)file).map(exampleClassInJar -> file.getAbsolutePath() + ": " + exampleClassInJar).stream()).collect(Collectors.joining("\n"));
        if (exampleBadClassesPerJar.isEmpty()) {
            return;
        }
        throw new RuntimeException(String.format("The %s classpath has the following jars which contain classes that have too high a java language version. We're expecting the bytecode major version to be no more than %d for java language version %d. Examples classes in each jar:\n\n%s", this.getClasspathName().get(), ((ChosenJavaVersion)this.getJavaVersion().get()).asBytecodeMajorVersion(), ((ChosenJavaVersion)this.getJavaVersion().get()).javaLanguageVersion().asInt(), exampleBadClassesPerJar));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> tooHighBytecodeMajorVersionInJar(File file) {
        try (JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));){
            String entryName;
            Optional<String> bytecodeMajorVersionTooHigh;
            boolean isntClassFile;
            boolean isMultiReleaseClass;
            do {
                JarEntry entry;
                if ((entry = jarInputStream.getNextJarEntry()) == null) return Optional.empty();
                entryName = entry.getName();
                isMultiReleaseClass = entryName.contains("META-INF/versions");
                boolean bl = isntClassFile = !entryName.endsWith(".class");
            } while (isMultiReleaseClass || isntClassFile || !(bytecodeMajorVersionTooHigh = CheckClasspathCompatible.bytecodeMajorVersionForClassFile(jarInputStream).filter(bytecodeMajorVersion -> bytecodeMajorVersion > ((ChosenJavaVersion)this.getJavaVersion().get()).asBytecodeMajorVersion()).map(bytecodeMajorVersion -> entryName + " has bytecode major version " + bytecodeMajorVersion)).isPresent());
            Optional<String> optional = bytecodeMajorVersionTooHigh;
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed when checking classpath compatibility of: " + file, e);
        }
    }

    private static Optional<Integer> bytecodeMajorVersionForClassFile(InputStream classFile) throws IOException {
        byte[] buf = new byte[4];
        ByteStreams.readFully((InputStream)classFile, (byte[])buf);
        int magic = Ints.fromByteArray((byte[])buf);
        if (magic != -889275714) {
            return Optional.empty();
        }
        ByteStreams.readFully((InputStream)classFile, (byte[])buf);
        int majorBytecodeVersion = 0xFFFF & Shorts.fromBytes((byte)buf[2], (byte)buf[3]);
        return Optional.of(majorBytecodeVersion);
    }
}

