/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class MultiLicenseHeaderStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "licenseHeader";
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("^(?! \\*|/\\*| \\*/)", 9);
    private final List<LicenseHeader> licenseHeaders;

    private MultiLicenseHeaderStep(List<LicenseHeader> licenseHeaders) {
        this.licenseHeaders = licenseHeaders;
    }

    public static FormatterStep createFromHeaders(List<String> templates) {
        List<LicenseHeader> headers = templates.stream().map(LicenseHeader::fromTemplate).collect(Collectors.toList());
        return FormatterStep.create((String)NAME, (Serializable)new MultiLicenseHeaderStep(headers), step -> step::format);
    }

    public static String name() {
        return NAME;
    }

    public String format(String raw) {
        Matcher matcher = DELIMITER_PATTERN.matcher(raw);
        Preconditions.checkArgument((boolean)matcher.find(), (String)"Raw input must match delimiter somewhere", (Object)DELIMITER_PATTERN, (Object)raw);
        String existingHeader = raw.substring(0, matcher.start());
        String rest = raw.substring(matcher.start());
        Optional<LicenseHeader> matchingHeader = this.licenseHeaders.stream().filter(header -> header.matches(existingHeader)).findFirst();
        if (matchingHeader.isPresent()) {
            return raw;
        }
        LicenseHeader preferredHeader = (LicenseHeader)Iterables.getLast(this.licenseHeaders);
        return preferredHeader.render(existingHeader) + rest;
    }

    private static class LicenseHeader
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Pattern YEAR_RANGE = Pattern.compile("[0-9]{4}(-[0-9]{4})?");
        private static final String YEAR_TOKEN = "${today.year}";
        private final String licenseHeaderBeforeYearToken;
        private final String licenseHeaderAfterYearToken;

        private LicenseHeader(String licenseHeader) {
            Preconditions.checkArgument((boolean)licenseHeader.contains(YEAR_TOKEN), (String)"License header must contain year token", (Object)YEAR_TOKEN, (Object)licenseHeader);
            int yearTokenIndex = licenseHeader.indexOf(YEAR_TOKEN);
            this.licenseHeaderBeforeYearToken = licenseHeader.substring(0, yearTokenIndex);
            this.licenseHeaderAfterYearToken = licenseHeader.substring(yearTokenIndex + YEAR_TOKEN.length());
        }

        static LicenseHeader fromTemplate(String template) {
            String unixEndings = LineEnding.toUnix((String)template.trim());
            Iterable lines = Splitter.on((char)'\n').split((CharSequence)unixEndings);
            String javadocHeader = Streams.stream((Iterable)lines).map(line -> line.isEmpty() ? " *" : " * " + line).collect(Collectors.joining("\n"));
            return new LicenseHeader("/*\n" + javadocHeader + "\n */\n");
        }

        private boolean matches(String existingHeader) {
            int startOfTheSecondPart = existingHeader.indexOf(this.licenseHeaderAfterYearToken);
            return startOfTheSecondPart > this.licenseHeaderBeforeYearToken.length() && existingHeader.startsWith(this.licenseHeaderBeforeYearToken) && startOfTheSecondPart + this.licenseHeaderAfterYearToken.length() == existingHeader.length() && YEAR_RANGE.matcher(existingHeader.substring(this.licenseHeaderBeforeYearToken.length(), startOfTheSecondPart)).matches();
        }

        private String render(String existingHeader) {
            Matcher yearInfo = YEAR_RANGE.matcher(existingHeader);
            boolean existingHeaderContainsYear = yearInfo.find();
            String year = existingHeaderContainsYear ? yearInfo.group(0) : String.valueOf(YearMonth.now().getYear());
            return this.licenseHeaderBeforeYearToken + year + this.licenseHeaderAfterYearToken;
        }
    }
}

