/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class BaselineModuleJvmArgsExtension {
    private final SetProperty<String> exports;
    private final SetProperty<String> opens;
    private final SetProperty<JavaLanguageVersion> enablePreview;

    @Inject
    public BaselineModuleJvmArgsExtension(Project project) {
        this.exports = project.getObjects().setProperty(String.class);
        this.opens = project.getObjects().setProperty(String.class);
        this.enablePreview = project.getObjects().setProperty(JavaLanguageVersion.class);
    }

    public final SetProperty<String> exports() {
        return this.exports;
    }

    public final void setExports(String ... input) {
        ImmutableSet immutableDeduplicatedCopy = ImmutableSet.copyOf((Object[])input);
        for (String export : immutableDeduplicatedCopy) {
            BaselineModuleJvmArgsExtension.validateModulePackagePair(export);
        }
        this.exports.set((Iterable)immutableDeduplicatedCopy);
    }

    public final SetProperty<String> opens() {
        return this.opens;
    }

    public final void setOpens(String ... input) {
        ImmutableSet immutableDeduplicatedCopy = ImmutableSet.copyOf((Object[])input);
        for (String export : immutableDeduplicatedCopy) {
            BaselineModuleJvmArgsExtension.validateModulePackagePair(export);
        }
        this.opens.set((Iterable)immutableDeduplicatedCopy);
    }

    public final void setEnablePreview(Provider<Optional<JavaLanguageVersion>> provider) {
        this.enablePreview.set(provider.map(maybeValue -> maybeValue.map(Set::of).orElseGet(Set::of)));
    }

    public final Provider<Set<JavaLanguageVersion>> getEnablePreview() {
        return this.enablePreview;
    }

    private static void validateModulePackagePair(String moduleAndPackage) {
        int lastSlash;
        if (moduleAndPackage.contains("=")) {
            throw new IllegalArgumentException(String.format("Value '%s' must not contain an '=', e.g. 'java.management/sun.management'. Each export implies a '=ALL-UNNAMED' suffix", moduleAndPackage));
        }
        if (moduleAndPackage.contains(" ")) {
            throw new IllegalArgumentException(String.format("Value '%s' must not contain whitespace", moduleAndPackage));
        }
        int firstSlash = moduleAndPackage.indexOf(47);
        if (firstSlash != (lastSlash = moduleAndPackage.lastIndexOf(47)) || firstSlash < 0) {
            throw new IllegalArgumentException(String.format("Value '%s' must contain both a module name and package name separated by a single slash, e.g. 'java.management/sun.management'", moduleAndPackage));
        }
    }
}

