/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.hash.HashCode;
import com.palantir.baseline.services.ClassUniquenessArtifactIdentifier;
import com.palantir.baseline.services.ImmutableClassUniquenessArtifactIdentifier;
import com.palantir.baseline.services.JarClassHasher;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.slf4j.Logger;

public final class ClassUniquenessAnalyzer {
    private final JarClassHasher jarHasher;
    private final SetMultimap<Set<ClassUniquenessArtifactIdentifier>, String> jarsToClasses = HashMultimap.create();
    private final SetMultimap<String, HashCode> classToHashCodes = HashMultimap.create();
    private final Logger log;

    public ClassUniquenessAnalyzer(JarClassHasher jarHasher, Logger log) {
        this.jarHasher = jarHasher;
        this.log = log;
    }

    public void analyzeConfiguration(Configuration configuration) {
        Instant before = Instant.now();
        Set dependencies = configuration.getResolvedConfiguration().getResolvedArtifacts();
        HashMultimap classToJars = HashMultimap.create();
        HashMultimap tempClassToHashCodes = HashMultimap.create();
        for (ResolvedArtifact resolvedArtifact : dependencies) {
            File file = resolvedArtifact.getFile();
            if (!file.exists()) {
                this.log.info("Skipping non-existent jar {}: {}", (Object)resolvedArtifact, (Object)file);
                return;
            }
            ImmutableSetMultimap<String, HashCode> hashes = this.jarHasher.hashClasses(resolvedArtifact, this.log).getHashesByClassName();
            for (Map.Entry entry2 : hashes.entries()) {
                String className = (String)entry2.getKey();
                HashCode hashValue = (HashCode)entry2.getValue();
                classToJars.put((Object)className, (Object)ImmutableClassUniquenessArtifactIdentifier.builder().moduleVersionIdentifier(resolvedArtifact.getModuleVersion().getId()).classifier(resolvedArtifact.getClassifier()).build());
                tempClassToHashCodes.put((Object)className, (Object)hashValue);
            }
        }
        classToJars.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).forEach(entry -> this.jarsToClasses.put((Object)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (Object)((String)entry.getKey())));
        tempClassToHashCodes.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).forEach(entry -> ((Collection)entry.getValue()).forEach(value -> this.classToHashCodes.put((Object)((String)entry.getKey()), value)));
        Instant after = Instant.now();
        this.log.info("Checked {} classes from {} dependencies for uniqueness ({}ms)", new Object[]{classToJars.size(), dependencies.size(), Duration.between(before, after).toMillis()});
    }

    private Collection<Set<ClassUniquenessArtifactIdentifier>> getProblemJars() {
        return this.jarsToClasses.keySet();
    }

    public Set<String> getSharedClassesInProblemJars(Set<ClassUniquenessArtifactIdentifier> problemJars) {
        return this.jarsToClasses.get(problemJars);
    }

    public Collection<Set<ClassUniquenessArtifactIdentifier>> getDifferingProblemJars() {
        return this.getProblemJars().stream().filter(jars -> this.getDifferingSharedClassesInProblemJars((Set<ClassUniquenessArtifactIdentifier>)jars).size() > 0).collect(Collectors.toSet());
    }

    public Set<String> getDifferingSharedClassesInProblemJars(Set<ClassUniquenessArtifactIdentifier> problemJars) {
        return this.getSharedClassesInProblemJars(problemJars).stream().filter(arg_0 -> this.classToHashCodes.containsKey(arg_0)).collect(Collectors.toSet());
    }
}

