/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.palantir.baseline.plugins.BaselineExactDependencies;
import com.palantir.gradle.failurereports.exceptions.ExceptionWithSuggestion;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CheckUnusedDependenciesTask
extends DefaultTask {
    private final ListProperty<Configuration> dependenciesConfigurations;
    private final ListProperty<Configuration> sourceOnlyConfigurations;
    private final Property<FileCollection> sourceClasses;
    private final SetProperty<String> ignore;

    public CheckUnusedDependenciesTask() {
        this.setGroup("Verification");
        this.setDescription("Ensures no extraneous dependencies are declared");
        this.dependenciesConfigurations = this.getProject().getObjects().listProperty(Configuration.class);
        this.dependenciesConfigurations.set(Collections.emptyList());
        this.sourceOnlyConfigurations = this.getProject().getObjects().listProperty(Configuration.class);
        this.sourceOnlyConfigurations.set(Collections.emptyList());
        this.sourceClasses = this.getProject().getObjects().property(FileCollection.class);
        this.ignore = this.getProject().getObjects().setProperty(String.class);
        this.ignore.set(Collections.emptySet());
        this.getOutputs().upToDateWhen(_task -> true);
    }

    @TaskAction
    public final void checkUnusedDependencies() {
        Set<ResolvedDependency> declaredDependencies = ((List)this.dependenciesConfigurations.get()).stream().map(Configuration::getResolvedConfiguration).flatMap(resolved -> resolved.getFirstLevelModuleDependencies().stream()).collect(Collectors.toSet());
        BaselineExactDependencies.INDEXES.populateIndexes(declaredDependencies);
        Set declaredArtifacts = declaredDependencies.stream().flatMap(dependency -> dependency.getModuleArtifacts().stream()).filter(dependency -> BaselineExactDependencies.VALID_ARTIFACT_EXTENSIONS.contains((Object)dependency.getExtension())).collect(Collectors.toSet());
        this.excludeSourceOnlyDependencies();
        Set necessaryArtifactsDeclaration = Streams.stream((Iterator)((FileCollection)this.sourceClasses.get()).iterator()).flatMap(BaselineExactDependencies::referencedClasses).flatMap(BaselineExactDependencies.INDEXES::classToArtifacts).map(BaselineExactDependencies::asString).collect(Collectors.toSet());
        Set possiblyUnused = declaredArtifacts.stream().filter(artifact -> !necessaryArtifactsDeclaration.contains(BaselineExactDependencies.asString(artifact))).collect(Collectors.toSet());
        this.getLogger().debug("Possibly unused dependencies: {}", possiblyUnused.stream().map(BaselineExactDependencies::asString).sorted().collect(Collectors.toList()));
        List declaredButUnused = possiblyUnused.stream().filter(artifact -> !this.shouldIgnore((ResolvedArtifact)artifact)).sorted(Comparator.comparing(BaselineExactDependencies::asString)).collect(Collectors.toList());
        if (!declaredButUnused.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Found %s dependencies unused during compilation, please delete them from '%s' or choose one of the suggested fixes:\n", declaredButUnused.size(), this.buildFile()));
            for (ResolvedArtifact resolvedArtifact : declaredButUnused) {
                builder.append('\t').append(BaselineExactDependencies.asDependencyStringWithName(resolvedArtifact)).append('\n');
                ResolvedDependency dependency2 = BaselineExactDependencies.INDEXES.artifactsFromDependency(resolvedArtifact);
                Set didYouMean = dependency2.getAllModuleArtifacts().stream().filter(artifact -> BaselineExactDependencies.VALID_ARTIFACT_EXTENSIONS.contains((Object)artifact.getExtension())).flatMap(BaselineExactDependencies.INDEXES::classesFromArtifact).filter(this.referencedClasses()::contains).flatMap(BaselineExactDependencies.INDEXES::classToArtifacts).filter(artifact -> !declaredArtifacts.contains(artifact)).collect(Collectors.toSet());
                if (didYouMean.isEmpty()) continue;
                builder.append("\t\tDid you mean:\n");
                didYouMean.stream().map(BaselineExactDependencies::asDependencyStringWithoutName).sorted().forEach(dependencyString -> builder.append("\t\t\t").append((String)dependencyString).append("\n"));
            }
            throw new ExceptionWithSuggestion(builder.toString(), this.buildFile().toString());
        }
    }

    private void excludeSourceOnlyDependencies() {
        ((List)this.sourceOnlyConfigurations.get()).forEach(config -> config.getResolvedConfiguration().getFirstLevelModuleDependencies().stream().flatMap(dependency -> dependency.getModuleArtifacts().stream()).forEach(artifact -> this.ignoreDependency((Configuration)config, (ResolvedArtifact)artifact)));
    }

    private void ignoreDependency(Configuration config, ResolvedArtifact artifact) {
        String dependencyId = BaselineExactDependencies.asString(artifact);
        this.getLogger().info("Ignoring {} dependency: {}", (Object)config.getName(), (Object)dependencyId);
        this.ignore.add((Object)dependencyId);
    }

    private Set<String> referencedClasses() {
        return Streams.stream((Iterator)((FileCollection)this.sourceClasses.get()).iterator()).flatMap(BaselineExactDependencies::referencedClasses).collect(Collectors.toSet());
    }

    private Path buildFile() {
        return this.getProject().getRootDir().toPath().relativize(this.getProject().getBuildFile().toPath());
    }

    private boolean shouldIgnore(ResolvedArtifact artifact) {
        return ((Set)this.ignore.get()).contains(BaselineExactDependencies.asString(artifact));
    }

    @Classpath
    public final ListProperty<Configuration> getDependenciesConfigurations() {
        return this.dependenciesConfigurations;
    }

    public final void dependenciesConfiguration(Configuration dependenciesConfiguration) {
        this.dependenciesConfigurations.add((Object)Objects.requireNonNull(dependenciesConfiguration));
    }

    @Input
    public final Provider<List<Configuration>> getSourceOnlyConfigurations() {
        return this.sourceOnlyConfigurations;
    }

    @Deprecated
    public final void sourceOnlyConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"This method requires a non-null configuration");
        Preconditions.checkArgument((boolean)configuration.isCanBeResolved(), (String)"May only add sourceOnlyConfiguration if it is resolvable: %s", (Object)configuration);
        this.sourceOnlyConfigurations.add((Object)Objects.requireNonNull(configuration));
    }

    @Classpath
    public final Provider<FileCollection> getSourceClasses() {
        return this.sourceClasses;
    }

    public final void setSourceClasses(FileCollection newClasses) {
        this.sourceClasses.set((Object)this.getProject().files(new Object[]{newClasses}));
    }

    public final void ignore(Provider<Set<String>> value) {
        this.ignore.addAll(value);
    }

    public final void ignore(String group, String name) {
        this.ignore.add((Object)BaselineExactDependencies.ignoreCoordinate(group, name));
    }

    @Input
    public final Provider<Set<String>> getIgnored() {
        return this.ignore;
    }
}

