/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.palantir.baseline.plugins.javaversions.BaselineJavaVersion;
import com.palantir.gradle.failurereports.exceptions.ExceptionWithSuggestion;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class CheckExplicitSourceCompatibilityTask
extends DefaultTask {
    private final Property<Boolean> shouldFix;

    @Inject
    public CheckExplicitSourceCompatibilityTask(ObjectFactory objectFactory) {
        this.setGroup("Verification");
        this.setDescription("Ensures build.gradle specifies sourceCompatibility explicitly, otherwise it is inferred based on $JAVA_HOME which is fragile.");
        this.shouldFix = objectFactory.property(Boolean.class);
        this.shouldFix.set((Object)false);
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !CheckExplicitSourceCompatibilityTask.this.getProject().getPlugins().hasPlugin(BaselineJavaVersion.class);
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                PublishingExtension publishing = (PublishingExtension)CheckExplicitSourceCompatibilityTask.this.getProject().getExtensions().findByType(PublishingExtension.class);
                if (publishing == null) {
                    return false;
                }
                return !publishing.getPublications().isEmpty();
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return ((SourceSetContainer)CheckExplicitSourceCompatibilityTask.this.getProject().getExtensions().getByType(SourceSetContainer.class)).stream().anyMatch(sourceSet -> !sourceSet.getAllJava().getFiles().isEmpty());
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                JavaPluginExtension maybeExtension = (JavaPluginExtension)CheckExplicitSourceCompatibilityTask.this.getProject().getExtensions().findByType(JavaPluginExtension.class);
                if (maybeExtension != null) {
                    JavaToolchainSpec toolchainSpec = maybeExtension.getToolchain();
                    return toolchainSpec == null || !toolchainSpec.getLanguageVersion().isPresent();
                }
                return true;
            }
        });
    }

    @Option(option="fix", description="Whether to apply the suggested fix to build.gradle")
    public final void setShouldFix(boolean value) {
        this.shouldFix.set((Object)value);
    }

    @TaskAction
    public final void taskAction() throws IOException {
        if (this.getRawSourceCompat() != null) {
            return;
        }
        if (((Boolean)this.shouldFix.get()).booleanValue()) {
            Files.write(this.getProject().getBuildFile().toPath(), Collections.singletonList(String.format("%nsourceCompatibility = %s%n", JavaVersion.current())), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            return;
        }
        String suggestion = String.format("./gradlew %s --fix", this.getPath());
        throw new ExceptionWithSuggestion(String.format("%s must set sourceCompatibility explicitly in '%s', otherwise compilation will not be reproducible but instead depends on the Java version that Gradle is currently running with (%s). To auto-fix, run%n%n     %s%n%nThis will automatically add a suggested line (you may need to adjust the number, e.g. to '1.8' for maximum compatibility).", this.getProject(), this.getProject().getRootProject().relativePath((Object)this.getProject().getBuildFile()), JavaVersion.current(), suggestion), suggestion);
    }

    private JavaVersion getRawSourceCompat() {
        DefaultJavaPluginExtension extension = (DefaultJavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        return extension.getRawSourceCompatibility();
    }
}

