/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import com.palantir.baseline.plugins.BaselineFormat;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class BaselineConfig
extends AbstractBaselinePlugin {
    BaselineConfig() {
    }

    public void apply(Project rootProject) {
        this.project = rootProject;
        if (!rootProject.equals(rootProject.getRootProject())) {
            throw new IllegalArgumentException(BaselineConfig.class.getCanonicalName() + " plugin can only be applied to the root project.");
        }
        Configuration configuration = (Configuration)rootProject.getConfigurations().create("baseline");
        Optional<String> version = Optional.ofNullable(((Object)((Object)this)).getClass().getPackage().getImplementationVersion());
        configuration.defaultDependencies(d -> d.add((Object)rootProject.getDependencies().create((Object)String.format("com.palantir.baseline:gradle-baseline-java-config%s@zip", version.map(v -> ":" + v).orElse("")))));
        rootProject.getTasks().register("baselineUpdateConfig", task -> {
            task.setGroup("Baseline");
            task.setDescription("Installs or updates Baseline configuration files in .baseline/");
            task.getInputs().files(new Object[]{configuration});
            task.getOutputs().dir((Object)this.getConfigDir());
            task.getOutputs().dir((Object)rootProject.getRootDir().toPath().resolve("project"));
            task.doLast((Action)new BaselineUpdateConfigAction(configuration, rootProject));
        });
    }

    private class BaselineUpdateConfigAction
    implements Action<Task> {
        private final Configuration configuration;
        private final Project rootProject;

        BaselineUpdateConfigAction(Configuration configuration, Project rootProject) {
            this.configuration = configuration;
            this.rootProject = rootProject;
        }

        public void execute(Task task) {
            if (this.configuration.getFiles().size() != 1) {
                throw new IllegalArgumentException("Expected to find exactly one config dependency in the 'baseline' configuration, found: " + this.configuration.getFiles());
            }
            Path configDir = Paths.get(BaselineConfig.this.getConfigDir(), new String[0]);
            this.rootProject.copy(copySpec -> {
                copySpec.from(new Object[]{this.rootProject.zipTree((Object)this.configuration.getSingleFile())});
                copySpec.into((Object)configDir);
                copySpec.exclude(new String[]{"**/scalastyle_config.xml"});
                copySpec.setIncludeEmptyDirs(false);
                if (!BaselineFormat.eclipseFormattingEnabled(task.getProject())) {
                    copySpec.exclude(new String[]{"**/spotless/eclipse.xml"});
                }
            });
            if (BaselineFormat.palantirJavaFormatterState(this.rootProject) != BaselineFormat.FormatterState.OFF || BaselineConfig.this.project.getPluginManager().hasPlugin("com.palantir.java-format-provider")) {
                Path checkstyleXml = configDir.resolve("checkstyle/checkstyle.xml");
                try {
                    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = builderFactory.newDocumentBuilder();
                    InputSource inputSource = new InputSource(new FileReader(checkstyleXml.toFile()));
                    inputSource.setEncoding("UTF-8");
                    Document document = builder.parse(inputSource);
                    XPathFactory xPathFactory = XPathFactory.newInstance();
                    XPath xPath = xPathFactory.newXPath();
                    this.removeNode(document, xPath, "//module[@name='Indentation']");
                    this.removeNode(document, xPath, "//module[@name='ParenPad']");
                    this.removeNode(document, xPath, "//module[@name='LeftCurly']");
                    this.removeNode(document, xPath, "//module[@name='WhitespaceAround']");
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
                    transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(new FileWriter(checkstyleXml.toFile()));
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to patch " + checkstyleXml, e);
                }
            }
        }

        private void removeNode(Document document, XPath xPath, String expression) throws XPathExpressionException {
            xPath.reset();
            Node node = (Node)xPath.compile(expression).evaluate(document, XPathConstants.NODE);
            node.getParentNode().removeChild(node);
        }
    }
}

