/*
 * Decompiled with CFR 0.152.
 */
package com.owlr.provider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.owlr.provider.MetaDataUtils;
import com.owlr.provider.SharedSharedPreferences;
import com.owlr.provider.Types;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SharedContentChangedReceiver
extends BroadcastReceiver
implements Types {
    public static final String SENDER_AUTHORITY_KEY = "sender_authority";

    public static void sendBroadcast(@NonNull Context context, @NonNull Map<String, ?> data) {
        String sharedPermission = MetaDataUtils.getSharedPermission(context);
        String senderAuthority = MetaDataUtils.getAppAuthority(context);
        Intent intent = new Intent(sharedPermission);
        intent.putExtra(SENDER_AUTHORITY_KEY, senderAuthority);
        SharedContentChangedReceiver.putDataIntoIntent(intent, data);
        context.sendBroadcast(intent, sharedPermission);
    }

    public void onReceive(Context context, Intent intent) {
        String appAuthority = MetaDataUtils.getAppAuthority(context);
        Log.d((String)"SharedProvider", (String)("Received Data Changed Event, SentByAuth [" + appAuthority + "]"));
        if (TextUtils.isEmpty((CharSequence)appAuthority) || appAuthority.equalsIgnoreCase(intent.getStringExtra(SENDER_AUTHORITY_KEY))) {
            Log.v((String)"SharedProvider", (String)("Skipped DataChange, SentByAuth [" + appAuthority + "]"));
            return;
        }
        SharedContentChangedReceiver.putIntentIntoSharedPreferences(context, intent.getExtras());
    }

    private static void putDataIntoIntent(Intent intent, Map<String, ?> data) {
        Set<Map.Entry<String, ?>> entries = data.entrySet();
        for (Map.Entry<String, ?> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                intent.putExtra(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                intent.putExtra(key, (Serializable)((Boolean)value));
                continue;
            }
            if (value instanceof Long) {
                intent.putExtra(key, (Serializable)((Long)value));
                continue;
            }
            if (value instanceof Integer) {
                intent.putExtra(key, (Serializable)((Integer)value));
                continue;
            }
            if (!(value instanceof Float)) continue;
            intent.putExtra(key, (Serializable)((Float)value));
        }
    }

    private static void putIntentIntoSharedPreferences(Context context, Bundle bundle) {
        Iterator keysIter = bundle.keySet().iterator();
        String appAuthority = MetaDataUtils.getAppAuthority(context);
        if (TextUtils.isEmpty((CharSequence)appAuthority)) {
            return;
        }
        SharedSharedPreferences localPrefs = new SharedSharedPreferences(context, appAuthority);
        SharedSharedPreferences.SharedEditor edit = localPrefs.edit();
        block7: while (keysIter.hasNext()) {
            String key;
            switch (key = (String)keysIter.next()) {
                case "master": 
                case "sender_authority": {
                    continue block7;
                }
            }
            Object value = bundle.get(key);
            if (value instanceof String) {
                edit.putString(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                edit.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Long) {
                edit.putLong(key, (Long)value);
                continue;
            }
            if (value instanceof Integer) {
                edit.putInt(key, (Integer)value);
                continue;
            }
            if (!(value instanceof Float)) continue;
            edit.putFloat(key, ((Float)value).floatValue());
        }
        edit.apply();
    }
}

