/*
 * Decompiled with CFR 0.152.
 */
package com.outsbook.libs.canvaseditor.stickers;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import androidx.core.content.ContextCompat;
import com.outsbook.libs.canvaseditor.R;
import com.outsbook.libs.canvaseditor.stickers.Sticker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0006\u0010-\u001a\u00020\u0000J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\b\u00100\u001a\u0004\u0018\u00010\u0019J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0012J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0012J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u000eJ\u0010\u0010<\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u00010>R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010\u00a8\u0006?"}, d2={"Lcom/outsbook/libs/canvaseditor/stickers/TextSticker;", "Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;)V", "alignment", "Landroid/text/Layout$Alignment;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "height", "", "getHeight", "()I", "lineSpacingExtra", "", "lineSpacingMultiplier", "mEllipsis", "", "maxTextSizePixels", "minTextSizePixels", "realBounds", "Landroid/graphics/Rect;", "staticLayout", "Landroid/text/StaticLayout;", "text", "textPaint", "Landroid/text/TextPaint;", "textRect", "width", "getWidth", "convertSpToPx", "scaledPixels", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getTextHeightPixels", "source", "", "availableWidthPixels", "textSizePixels", "resizeText", "setAlpha", "alpha", "region", "setLineSpacing", "add", "multiplier", "setMaxTextSize", "size", "setMinTextSize", "minTextSizeScaledPixels", "setText", "setTextAlign", "setTextColor", "color", "setTypeface", "typeface", "Landroid/graphics/Typeface;", "canvaseditor_release"})
public final class TextSticker
extends Sticker {
    @NotNull
    public Drawable drawable;
    private String text;
    private final String mEllipsis = "\u2026";
    private final Rect realBounds;
    private final Rect textRect;
    private final TextPaint textPaint;
    private StaticLayout staticLayout;
    private Layout.Alignment alignment;
    private float maxTextSizePixels;
    private float minTextSizePixels;
    private float lineSpacingMultiplier;
    private float lineSpacingExtra;
    private final Context context;

    @Override
    @NotNull
    public Drawable getDrawable() {
        Drawable drawable2 = this.drawable;
        if (drawable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawable");
        }
        return drawable2;
    }

    public void setDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"<set-?>");
        this.drawable = drawable2;
    }

    @Override
    public int getWidth() {
        return this.getDrawable().getIntrinsicWidth();
    }

    @Override
    public int getHeight() {
        return this.getDrawable().getIntrinsicHeight();
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Matrix matrix = this.getMatrix();
        canvas.save();
        canvas.concat(matrix);
        this.getDrawable().setBounds(this.realBounds);
        this.getDrawable().draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.concat(matrix);
        if (this.textRect.width() == this.getWidth()) {
            int n = this.getHeight() / 2;
            StaticLayout staticLayout = this.staticLayout;
            if (staticLayout == null) {
                Intrinsics.throwNpe();
            }
            int dy = n - staticLayout.getHeight() / 2;
            canvas.translate(0.0f, (float)dy);
        } else {
            int dx = this.textRect.left;
            int n = this.textRect.top + this.textRect.height() / 2;
            StaticLayout staticLayout = this.staticLayout;
            if (staticLayout == null) {
                Intrinsics.throwNpe();
            }
            int dy = n - staticLayout.getHeight() / 2;
            canvas.translate((float)dx, (float)dy);
        }
        StaticLayout staticLayout = this.staticLayout;
        if (staticLayout == null) {
            Intrinsics.throwNpe();
        }
        staticLayout.draw(canvas);
        canvas.restore();
    }

    @Override
    @NotNull
    public TextSticker setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
        return this;
    }

    @Override
    @NotNull
    public TextSticker setDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        this.setDrawable(drawable2);
        this.realBounds.set(0, 0, this.getWidth(), this.getHeight());
        this.textRect.set(0, 0, this.getWidth(), this.getHeight());
        return this;
    }

    @NotNull
    public final TextSticker setDrawable(@NotNull Drawable drawable2, @Nullable Rect region) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        this.setDrawable(drawable2);
        this.realBounds.set(0, 0, this.getWidth(), this.getHeight());
        if (region == null) {
            this.textRect.set(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.textRect.set(region.left, region.top, region.right, region.bottom);
        }
        return this;
    }

    @NotNull
    public final TextSticker setText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        return this;
    }

    @NotNull
    public final TextSticker setTypeface(@Nullable Typeface typeface) {
        this.textPaint.setTypeface(typeface);
        return this;
    }

    @NotNull
    public final TextSticker setTextColor(int color) {
        this.textPaint.setColor(color);
        return this;
    }

    @NotNull
    public final TextSticker setTextAlign(@NotNull Layout.Alignment alignment) {
        Intrinsics.checkParameterIsNotNull((Object)alignment, (String)"alignment");
        this.alignment = alignment;
        return this;
    }

    @NotNull
    public final TextSticker setMaxTextSize(float size) {
        this.textPaint.setTextSize(this.convertSpToPx(size));
        this.maxTextSizePixels = this.textPaint.getTextSize();
        return this;
    }

    @NotNull
    public final TextSticker setMinTextSize(float minTextSizeScaledPixels) {
        this.minTextSizePixels = this.convertSpToPx(minTextSizeScaledPixels);
        return this;
    }

    @NotNull
    public final TextSticker setLineSpacing(float add, float multiplier) {
        this.lineSpacingMultiplier = multiplier;
        this.lineSpacingExtra = add;
        return this;
    }

    @NotNull
    public final TextSticker resizeText() {
        StaticLayout staticLayout;
        CharSequence text;
        int availableWidthPixels;
        int availableHeightPixels;
        block13: {
            block12: {
                availableHeightPixels = this.textRect.height();
                availableWidthPixels = this.textRect.width();
                text = this.text;
                if (text == null) break block12;
                CharSequence charSequence = text;
                boolean bl = false;
                if (!(charSequence.length() == 0) && availableHeightPixels > 0 && availableWidthPixels > 0 && !(this.maxTextSizePixels <= 0.0f)) break block13;
            }
            return this;
        }
        float targetTextSizePixels = this.maxTextSizePixels;
        int targetTextHeightPixels = this.getTextHeightPixels(text, availableWidthPixels, targetTextSizePixels);
        while (targetTextHeightPixels > availableHeightPixels && targetTextSizePixels > this.minTextSizePixels) {
            targetTextSizePixels = Math.max(targetTextSizePixels - (float)2, this.minTextSizePixels);
            targetTextHeightPixels = this.getTextHeightPixels(text, availableWidthPixels, targetTextSizePixels);
        }
        if (targetTextSizePixels == this.minTextSizePixels && targetTextHeightPixels > availableHeightPixels) {
            int lastLine;
            TextPaint textPaintCopy = new TextPaint((Paint)this.textPaint);
            textPaintCopy.setTextSize(targetTextSizePixels);
            StaticLayout staticLayout2 = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaintCopy, (int)availableWidthPixels).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier).setIncludePad(false).build() : new StaticLayout(text, textPaintCopy, availableWidthPixels, Layout.Alignment.ALIGN_NORMAL, this.lineSpacingMultiplier, this.lineSpacingExtra, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout2, (String)"if (Build.VERSION.SDK_IN\u2026         ))\n            }");
            StaticLayout staticLayout3 = staticLayout2;
            if (staticLayout3.getLineCount() > 0 && (lastLine = staticLayout3.getLineForVertical(availableHeightPixels) - 1) >= 0) {
                int startOffset = staticLayout3.getLineStart(lastLine);
                int endOffset = staticLayout3.getLineEnd(lastLine);
                float lineWidthPixels = staticLayout3.getLineWidth(lastLine);
                float ellipseWidth = textPaintCopy.measureText(this.mEllipsis);
                while ((float)availableWidthPixels < lineWidthPixels + ellipseWidth) {
                    lineWidthPixels = textPaintCopy.measureText(((Object)text.subSequence(startOffset, --endOffset + 1)).toString());
                }
                this.setText(((Object)text.subSequence(0, endOffset)).toString() + this.mEllipsis);
            }
        }
        this.textPaint.setTextSize(targetTextSizePixels);
        if (Build.VERSION.SDK_INT >= 23) {
            String string = this.text;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            CharSequence charSequence = string;
            String string2 = this.text;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            staticLayout = StaticLayout.Builder.obtain((CharSequence)charSequence, (int)0, (int)string2.length(), (TextPaint)this.textPaint, (int)this.textRect.width()).setAlignment(this.alignment).setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier).setIncludePad(true).build();
        } else {
            String string = this.text;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            staticLayout = new StaticLayout((CharSequence)string, this.textPaint, availableWidthPixels, this.alignment, this.lineSpacingMultiplier, this.lineSpacingExtra, true);
        }
        this.staticLayout = staticLayout;
        return this;
    }

    private final int getTextHeightPixels(CharSequence source, int availableWidthPixels, float textSizePixels) {
        this.textPaint.setTextSize(textSizePixels);
        StaticLayout staticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)source, (int)0, (int)0, (TextPaint)this.textPaint, (int)availableWidthPixels).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier).setIncludePad(true).build() : new StaticLayout(source, this.textPaint, availableWidthPixels, Layout.Alignment.ALIGN_NORMAL, this.lineSpacingMultiplier, this.lineSpacingExtra, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout, (String)"if (Build.VERSION.SDK_IN\u2026\n            ))\n        }");
        StaticLayout staticLayout2 = staticLayout;
        return staticLayout2.getHeight();
    }

    private final float convertSpToPx(float scaledPixels) {
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return scaledPixels * resources.getDisplayMetrics().scaledDensity;
    }

    public TextSticker(@NotNull Context context, @Nullable Drawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.mEllipsis = "\u2026";
        this.lineSpacingMultiplier = 1.0f;
        if (drawable2 == null) {
            Drawable drawable3 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.shape_transfarent_background);
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            this.setDrawable(drawable3);
        } else {
            this.setDrawable(drawable2);
        }
        this.textPaint = new TextPaint(1);
        this.realBounds = new Rect(0, 0, this.getWidth(), this.getHeight());
        this.textRect = new Rect(0, 0, this.getWidth(), this.getHeight());
        this.minTextSizePixels = this.convertSpToPx(6.0f);
        this.maxTextSizePixels = this.convertSpToPx(32.0f);
        this.alignment = Layout.Alignment.ALIGN_CENTER;
        this.textPaint.setTextSize(this.maxTextSizePixels);
    }
}

