/*
 * Decompiled with CFR 0.152.
 */
package com.outsbook.libs.canvaseditor.stickers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.outsbook.libs.canvaseditor.R;
import com.outsbook.libs.canvaseditor.constants.ActionMode;
import com.outsbook.libs.canvaseditor.constants.ConstantSticker;
import com.outsbook.libs.canvaseditor.enums.DrawType;
import com.outsbook.libs.canvaseditor.events.DeleteIconEvent;
import com.outsbook.libs.canvaseditor.events.DoneIconEvent;
import com.outsbook.libs.canvaseditor.events.FlipIconEvent;
import com.outsbook.libs.canvaseditor.events.ZoomIconEvent;
import com.outsbook.libs.canvaseditor.listeners.StickerViewListener;
import com.outsbook.libs.canvaseditor.models.DrawObject;
import com.outsbook.libs.canvaseditor.stickers.Sticker;
import com.outsbook.libs.canvaseditor.stickers.StickerIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b!\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0013J\u0018\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0012\u00101\u001a\u00020\u001b2\b\u00102\u001a\u0004\u0018\u000103H\u0002J(\u00101\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001bH\u0002J\b\u00108\u001a\u00020\rH\u0002J\u0012\u00108\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0012\u00109\u001a\u00020\u001b2\b\u00102\u001a\u0004\u0018\u000103H\u0002J(\u00109\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001bH\u0002J\b\u0010:\u001a\u000200H\u0002J(\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u001bH\u0002J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020BH\u0014J\u0006\u0010C\u001a\u000200J\u0012\u0010D\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010E\u001a\u0002002\u0006\u0010A\u001a\u00020BH\u0002J\n\u0010F\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010G\u001a\u000200J\u0012\u0010H\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u0013H\u0002J\u001a\u0010I\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010J\u001a\u00020\bH\u0002J\u0010\u0010K\u001a\u0002002\u0006\u00102\u001a\u000203H\u0002J \u0010L\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u000203H\u0016J0\u0010O\u001a\u0002002\u0006\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020\u00112\u0006\u0010R\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\u0011H\u0014J(\u0010U\u001a\u0002002\u0006\u0010V\u001a\u00020\u00112\u0006\u0010W\u001a\u00020\u00112\u0006\u0010X\u001a\u00020\u00112\u0006\u0010Y\u001a\u00020\u0011H\u0014J\u0010\u0010Z\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010[\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0017J\u0010\u0010\\\u001a\u0002002\u0006\u00102\u001a\u000203H\u0002J\u0006\u0010]\u001a\u000200J\u0012\u0010^\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010_\u001a\u0002002\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010`\u001a\u0002002\u0006\u0010-\u001a\u00020\u0013H\u0002J\u000e\u0010a\u001a\u0002002\u0006\u00102\u001a\u000203J\u001a\u0010b\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/outsbook/libs/canvaseditor/stickers/StickerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "stickerViewListener", "Lcom/outsbook/libs/canvaseditor/listeners/StickerViewListener;", "(Landroid/content/Context;Lcom/outsbook/libs/canvaseditor/listeners/StickerViewListener;)V", "bitmapPoints", "", "borderPaint", "Landroid/graphics/Paint;", "bounds", "currentCenterPoint", "Landroid/graphics/PointF;", "currentIcon", "Lcom/outsbook/libs/canvaseditor/stickers/StickerIcon;", "currentMode", "", "currentSticker", "Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "getCurrentSticker", "()Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "setCurrentSticker", "(Lcom/outsbook/libs/canvaseditor/stickers/Sticker;)V", "downMatrix", "Landroid/graphics/Matrix;", "downX", "", "downY", "iconPaint", "icons", "", "isTouchInsideSticker", "", "midPoint", "moveMatrix", "oldDistance", "oldRotation", "point", "sizeMatrix", "stickerRect", "Landroid/graphics/RectF;", "tmp", "touchSlop", "addSticker", "sticker", "position", "addStickerImmediately", "", "calculateDistance", "event", "Landroid/view/MotionEvent;", "x1", "y1", "x2", "y2", "calculateMidPoint", "calculateRotation", "configDefaultIcons", "configIconMatrix", "icon", "x", "y", "rotation", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "done", "doneSticker", "drawStickers", "findCurrentIconTouched", "flip", "flipSticker", "getStickerPoints", "dst", "handleCurrentMode", "isInStickerArea", "onInterceptTouchEvent", "ev", "onLayout", "changed", "left", "top", "right", "bottom", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchDown", "onTouchEvent", "onTouchUp", "remove", "removeSticker", "setStickerPosition", "transformSticker", "zoomAndRotate", "zoomAndRotateSticker", "canvaseditor_release"})
public final class StickerView
extends FrameLayout {
    @Nullable
    private Sticker currentSticker;
    private int currentMode;
    private boolean isTouchInsideSticker;
    private final RectF stickerRect;
    private final List<StickerIcon> icons;
    private final float[] bitmapPoints;
    private final float[] bounds;
    private final float[] point;
    private final PointF currentCenterPoint;
    private final float[] tmp;
    private PointF midPoint;
    private final Matrix sizeMatrix;
    private final Matrix downMatrix;
    private final Matrix moveMatrix;
    private float downX;
    private float downY;
    private float oldDistance;
    private float oldRotation;
    private final Paint borderPaint;
    private final Paint iconPaint;
    private final int touchSlop;
    private StickerIcon currentIcon;
    private final StickerViewListener stickerViewListener;
    private HashMap _$_findViewCache;

    @Nullable
    public final Sticker getCurrentSticker() {
        return this.currentSticker;
    }

    public final void setCurrentSticker(@Nullable Sticker sticker) {
        this.currentSticker = sticker;
    }

    private final void configDefaultIcons() {
        StickerIcon deleteIcon = new StickerIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_close_white_20dp), 0);
        deleteIcon.setIconListener(new DeleteIconEvent());
        StickerIcon doneIcon = new StickerIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_done_white_20dp), 1);
        doneIcon.setIconListener(new DoneIconEvent());
        StickerIcon zoomIcon = new StickerIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_rotate_scale_white_17dp), 3);
        zoomIcon.setIconListener(new ZoomIconEvent());
        StickerIcon flipIcon = new StickerIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_flip_white_20dp), 2);
        flipIcon.setIconListener(new FlipIconEvent());
        this.icons.clear();
        this.icons.add(deleteIcon);
        this.icons.add(doneIcon);
        this.icons.add(zoomIcon);
        this.icons.add(flipIcon);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        block0: {
            super.onSizeChanged(w, h, oldw, oldh);
            Sticker sticker = this.currentSticker;
            if (sticker == null) break block0;
            Sticker sticker2 = sticker;
            boolean bl = false;
            boolean bl2 = false;
            Sticker it = sticker2;
            boolean bl3 = false;
            this.transformSticker(it);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.stickerRect.left = left;
            this.stickerRect.top = top;
            this.stickerRect.right = right;
            this.stickerRect.bottom = bottom;
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        this.drawStickers(canvas);
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        switch (ev.getAction()) {
            case 0: {
                this.downX = ev.getX();
                this.downY = ev.getY();
                return this.findCurrentIconTouched() != null || this.currentSticker != null;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.stickerViewListener.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                if (this.onTouchDown(event)) break;
                return false;
            }
            case 5: {
                this.oldDistance = this.calculateDistance(event);
                this.oldRotation = this.calculateRotation(event);
                this.midPoint = this.calculateMidPoint(event);
                if (this.currentSticker == null) break;
                Sticker sticker = this.currentSticker;
                if (sticker == null) {
                    Intrinsics.throwNpe();
                }
                if (!this.isInStickerArea(sticker, event.getX(1), event.getY(1)) || this.findCurrentIconTouched() != null) break;
                this.currentMode = ActionMode.Companion.getZOOM_WITH_TWO_FINGER();
                break;
            }
            case 2: {
                this.handleCurrentMode(event);
                this.invalidate();
                break;
            }
            case 1: {
                this.onTouchUp(event);
                break;
            }
            case 6: {
                this.currentMode = ActionMode.Companion.getNONE();
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawStickers(Canvas canvas) {
        Sticker sticker = this.currentSticker;
        if (sticker != null) {
            sticker.draw(canvas);
        }
        if (this.currentSticker != null) {
            this.getStickerPoints(this.currentSticker, this.bitmapPoints);
            float x1 = this.bitmapPoints[0];
            float y1 = this.bitmapPoints[1];
            float x2 = this.bitmapPoints[2];
            float y2 = this.bitmapPoints[3];
            float x3 = this.bitmapPoints[4];
            float y3 = this.bitmapPoints[5];
            float x4 = this.bitmapPoints[6];
            float y4 = this.bitmapPoints[7];
            canvas.drawLine(x1, y1, x2, y2, this.borderPaint);
            canvas.drawLine(x1, y1, x3, y3, this.borderPaint);
            canvas.drawLine(x2, y2, x4, y4, this.borderPaint);
            canvas.drawLine(x4, y4, x3, y3, this.borderPaint);
            float rotation = this.calculateRotation(x4, y4, x3, y3);
            int n = 0;
            int n2 = ((Collection)this.icons).size();
            while (n < n2) {
                void i;
                StickerIcon icon = this.icons.get((int)i);
                switch (icon.getPosition()) {
                    case 0: {
                        this.configIconMatrix(icon, x1, y1, rotation);
                        break;
                    }
                    case 1: {
                        this.configIconMatrix(icon, x2, y2, rotation);
                        break;
                    }
                    case 2: {
                        this.configIconMatrix(icon, x3, y3, rotation);
                        break;
                    }
                    case 3: {
                        this.configIconMatrix(icon, x4, y4, rotation);
                        break;
                    }
                }
                icon.draw(canvas, this.iconPaint);
                ++i;
            }
        }
    }

    private final void getStickerPoints(Sticker sticker, float[] dst) {
        if (sticker == null) {
            Arrays.fill(dst, 0.0f);
            return;
        }
        sticker.getBoundPoints(this.bounds);
        sticker.getMappedPoints(dst, this.bounds);
    }

    private final float calculateDistance(MotionEvent event) {
        return event == null || event.getPointerCount() < 2 ? 0.0f : this.calculateDistance(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
    }

    private final float calculateDistance(float x1, float y1, float x2, float y2) {
        double x = (double)x1 - (double)x2;
        double y = (double)y1 - (double)y2;
        double d = x * x + y * y;
        boolean bl = false;
        return (float)Math.sqrt(d);
    }

    private final float calculateRotation(MotionEvent event) {
        return event == null || event.getPointerCount() < 2 ? 0.0f : this.calculateRotation(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
    }

    private final float calculateRotation(float x1, float y1, float x2, float y2) {
        double x = (double)x1 - (double)x2;
        double y = (double)y1 - (double)y2;
        boolean bl = false;
        double radians = Math.atan2(y, x);
        return (float)Math.toDegrees(radians);
    }

    private final void configIconMatrix(StickerIcon icon, float x, float y, float rotation) {
        icon.setX(x);
        icon.setY(y);
        icon.getMatrix().reset();
        icon.getMatrix().postRotate(rotation, (float)icon.getWidth() / (float)2, (float)icon.getHeight() / (float)2);
        icon.getMatrix().postTranslate(x - (float)(icon.getWidth() / 2), y - (float)(icon.getHeight() / 2));
    }

    private final void transformSticker(Sticker sticker) {
        this.sizeMatrix.reset();
        float width = this.getWidth();
        float height = this.getHeight();
        float stickerWidth = sticker.getWidth();
        float stickerHeight = sticker.getHeight();
        float offsetX = (width - stickerWidth) / (float)2;
        float offsetY = (height - stickerHeight) / (float)2;
        this.sizeMatrix.postTranslate(offsetX, offsetY);
        float scaleFactor = 0.0f;
        scaleFactor = width < height ? width / stickerWidth : height / stickerHeight;
        this.sizeMatrix.postScale(scaleFactor / 2.0f, scaleFactor / 2.0f, width / 2.0f, height / 2.0f);
        sticker.getMatrix().reset();
        sticker.setMatrix(this.sizeMatrix);
        this.invalidate();
    }

    private final StickerIcon findCurrentIconTouched() {
        for (StickerIcon icon : this.icons) {
            float x = icon.getX() - this.downX;
            float y = icon.getY() - this.downY;
            float distancePow2 = x * x + y * y;
            double d = (double)icon.getIconRadius() + (double)icon.getIconRadius();
            double d2 = 2.0;
            double d3 = distancePow2;
            boolean bl = false;
            double d4 = Math.pow(d, d2);
            if (!(d3 <= d4)) continue;
            return icon;
        }
        return null;
    }

    private final boolean onTouchDown(MotionEvent event) {
        this.currentMode = ActionMode.Companion.getDRAG();
        this.downX = event.getX();
        this.downY = event.getY();
        this.midPoint = this.calculateMidPoint();
        this.oldDistance = this.calculateDistance(this.midPoint.x, this.midPoint.y, this.downX, this.downY);
        this.oldRotation = this.calculateRotation(this.midPoint.x, this.midPoint.y, this.downX, this.downY);
        this.currentIcon = this.findCurrentIconTouched();
        if (this.currentIcon != null) {
            this.currentMode = ActionMode.Companion.getICON();
            StickerIcon stickerIcon = this.currentIcon;
            if (stickerIcon == null) {
                Intrinsics.throwNpe();
            }
            stickerIcon.onActionDown(this, event);
        }
        if (this.currentSticker != null) {
            Sticker sticker = this.currentSticker;
            if (sticker == null) {
                Intrinsics.throwNpe();
            }
            this.isTouchInsideSticker = sticker.contains(this.downX, this.downY);
            Sticker sticker2 = this.currentSticker;
            if (sticker2 == null) {
                Intrinsics.throwNpe();
            }
            this.downMatrix.set(Sticker.Companion.getMatrix(sticker2));
        }
        if (this.currentIcon == null && !this.isTouchInsideSticker) {
            this.doneSticker(this.currentSticker);
            return false;
        }
        this.invalidate();
        return true;
    }

    private final void handleCurrentMode(MotionEvent event) {
        block3: {
            int n;
            block5: {
                block4: {
                    n = this.currentMode;
                    if (n == ActionMode.Companion.getNONE() || n == ActionMode.Companion.getCLICK()) break block3;
                    if (n != ActionMode.Companion.getDRAG()) break block4;
                    if (this.currentSticker == null || !this.isTouchInsideSticker) break block3;
                    this.moveMatrix.set(this.downMatrix);
                    this.moveMatrix.postTranslate(event.getX() - this.downX, event.getY() - this.downY);
                    Sticker sticker = this.currentSticker;
                    if (sticker == null) {
                        Intrinsics.throwNpe();
                    }
                    sticker.setMatrix(this.moveMatrix);
                    break block3;
                }
                if (n != ActionMode.Companion.getZOOM_WITH_TWO_FINGER()) break block5;
                if (this.currentSticker == null || !this.isTouchInsideSticker) break block3;
                float newDistance = this.calculateDistance(event);
                float newRotation = this.calculateRotation(event);
                this.moveMatrix.set(this.downMatrix);
                this.moveMatrix.postScale(newDistance / this.oldDistance, newDistance / this.oldDistance, this.midPoint.x, this.midPoint.y);
                this.moveMatrix.postRotate(newRotation - this.oldRotation, this.midPoint.x, this.midPoint.y);
                Sticker sticker = this.currentSticker;
                if (sticker == null) {
                    Intrinsics.throwNpe();
                }
                sticker.setMatrix(this.moveMatrix);
                break block3;
            }
            if (n != ActionMode.Companion.getICON() || this.currentSticker == null || this.currentIcon == null) break block3;
            StickerIcon stickerIcon = this.currentIcon;
            if (stickerIcon == null) {
                Intrinsics.throwNpe();
            }
            stickerIcon.onActionMove(this, event);
        }
    }

    private final void onTouchUp(MotionEvent event) {
        if (this.currentMode == ActionMode.Companion.getICON() && this.currentIcon != null && this.currentSticker != null) {
            StickerIcon stickerIcon = this.currentIcon;
            if (stickerIcon == null) {
                Intrinsics.throwNpe();
            }
            stickerIcon.onActionUp(this, event);
        }
        if (this.currentMode == ActionMode.Companion.getDRAG()) {
            float f = event.getX() - this.downX;
            boolean bl = false;
            if (Math.abs(f) < (float)this.touchSlop) {
                f = event.getY() - this.downY;
                bl = false;
                if (Math.abs(f) < (float)this.touchSlop && this.currentSticker != null) {
                    if (!this.isTouchInsideSticker) {
                        this.stickerViewListener.onClickStickerOutside(event.getX(), event.getY());
                    }
                    this.currentMode = ActionMode.Companion.getCLICK();
                }
            }
        }
        this.currentMode = ActionMode.Companion.getNONE();
    }

    private final PointF calculateMidPoint(MotionEvent event) {
        if (event == null || event.getPointerCount() < 2) {
            this.midPoint.set(0.0f, 0.0f);
            return this.midPoint;
        }
        float x = (event.getX(0) + event.getX(1)) / (float)2;
        float y = (event.getY(0) + event.getY(1)) / (float)2;
        this.midPoint.set(x, y);
        return this.midPoint;
    }

    private final PointF calculateMidPoint() {
        block1: {
            if (this.currentSticker == null) {
                this.midPoint.set(0.0f, 0.0f);
                return this.midPoint;
            }
            Sticker sticker = this.currentSticker;
            if (sticker == null) break block1;
            sticker.getMappedCenterPoint(this.midPoint, this.point, this.tmp);
        }
        return this.midPoint;
    }

    private final boolean isInStickerArea(Sticker sticker, float downX, float downY) {
        this.tmp[0] = downX;
        this.tmp[1] = downY;
        return sticker.contains(this.tmp);
    }

    @NotNull
    public final StickerView addSticker(@NotNull Sticker sticker) {
        Intrinsics.checkParameterIsNotNull((Object)sticker, (String)"sticker");
        return this.addSticker(sticker, ConstantSticker.Companion.getCENTER());
    }

    private final StickerView addSticker(Sticker sticker, int position) {
        if (ViewCompat.isLaidOut((View)((View)this))) {
            this.addStickerImmediately(sticker, position);
        } else {
            this.post(new Runnable(this, sticker, position){
                final /* synthetic */ StickerView this$0;
                final /* synthetic */ Sticker $sticker;
                final /* synthetic */ int $position;

                public final void run() {
                    StickerView.access$addStickerImmediately(this.this$0, this.$sticker, this.$position);
                }
                {
                    this.this$0 = stickerView;
                    this.$sticker = sticker;
                    this.$position = n;
                }
            });
        }
        return this;
    }

    private final void addStickerImmediately(Sticker sticker, int position) {
        this.setStickerPosition(sticker, position);
        float scaleFactor = 0.0f;
        float widthScaleFactor = (float)this.getWidth() / (float)sticker.getDrawable().getIntrinsicWidth();
        float heightScaleFactor = (float)this.getHeight() / (float)sticker.getDrawable().getIntrinsicHeight();
        scaleFactor = widthScaleFactor > heightScaleFactor ? heightScaleFactor : widthScaleFactor;
        sticker.getMatrix().postScale(scaleFactor / (float)2, scaleFactor / (float)2, (float)this.getWidth() / (float)2, (float)this.getHeight() / (float)2);
        this.currentSticker = sticker;
        this.invalidate();
    }

    private final void setStickerPosition(Sticker sticker, int position) {
        float width = this.getWidth();
        float height = this.getHeight();
        float offsetX = width - (float)sticker.getWidth();
        float offsetY = height - (float)sticker.getHeight();
        offsetY = (position & ConstantSticker.Companion.getTOP()) > 0 ? (offsetY /= 4.0f) : ((position & ConstantSticker.Companion.getBOTTOM()) > 0 ? (offsetY *= 0.75f) : (offsetY /= 2.0f));
        offsetX = (position & ConstantSticker.Companion.getLEFT()) > 0 ? (offsetX /= 4.0f) : ((position & ConstantSticker.Companion.getRIGHT()) > 0 ? (offsetX *= 0.75f) : (offsetX /= 2.0f));
        sticker.getMatrix().postTranslate(offsetX, offsetY);
    }

    private final void removeSticker(Sticker sticker) {
        if (sticker == null) {
            return;
        }
        this.currentSticker = null;
        this.setVisibility(8);
        this.stickerViewListener.onRemove();
    }

    private final void doneSticker(Sticker sticker) {
        if (sticker == null) {
            return;
        }
        this.currentSticker = null;
        this.setVisibility(8);
        DrawObject obj = new DrawObject(null, sticker, DrawType.STICKER);
        this.stickerViewListener.onDone(obj);
    }

    private final void zoomAndRotateSticker(Sticker sticker, MotionEvent event) {
        if (sticker == null) {
            return;
        }
        float newDistance = this.calculateDistance(this.midPoint.x, this.midPoint.y, event.getX(), event.getY());
        float newRotation = this.calculateRotation(this.midPoint.x, this.midPoint.y, event.getX(), event.getY());
        this.moveMatrix.set(this.downMatrix);
        this.moveMatrix.postScale(newDistance / this.oldDistance, newDistance / this.oldDistance, this.midPoint.x, this.midPoint.y);
        this.moveMatrix.postRotate(newRotation - this.oldRotation, this.midPoint.x, this.midPoint.y);
        Sticker sticker2 = this.currentSticker;
        if (sticker2 == null) {
            Intrinsics.throwNpe();
        }
        sticker2.setMatrix(this.moveMatrix);
        this.stickerViewListener.onZoomAndRotate();
    }

    private final void flipSticker(Sticker sticker) {
        if (sticker == null) {
            return;
        }
        sticker.getCenterPoint(this.midPoint);
        sticker.getMatrix().preScale(-1.0f, 1.0f, this.midPoint.x, this.midPoint.y);
        sticker.setFlippedHorizontally(!sticker.isFlippedHorizontally());
        this.invalidate();
        this.stickerViewListener.onFlip();
    }

    public final void remove() {
        this.removeSticker(this.currentSticker);
    }

    public final void done() {
        this.doneSticker(this.currentSticker);
    }

    public final void zoomAndRotate(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.zoomAndRotateSticker(this.currentSticker, event);
    }

    public final void flip() {
        this.flipSticker(this.currentSticker);
    }

    public StickerView(@NotNull Context context, @NotNull StickerViewListener stickerViewListener2) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stickerViewListener2, (String)"stickerViewListener");
        super(context);
        this.stickerViewListener = stickerViewListener2;
        this.currentMode = ActionMode.Companion.getNONE();
        this.stickerRect = new RectF();
        this.icons = new ArrayList(4);
        this.bitmapPoints = new float[8];
        this.bounds = new float[8];
        this.point = new float[2];
        this.currentCenterPoint = new PointF();
        this.tmp = new float[2];
        this.midPoint = new PointF();
        this.sizeMatrix = new Matrix();
        this.downMatrix = new Matrix();
        this.moveMatrix = new Matrix();
        Paint paint2 = new Paint();
        StickerView stickerView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setColor(-16777216);
        $this$apply.setAlpha(50);
        stickerView.borderPaint = paint = paint2;
        paint2 = new Paint();
        stickerView = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setColor(-16777216);
        $this$apply.setAlpha(128);
        stickerView.iconPaint = paint = paint2;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.touchSlop = viewConfiguration.getScaledTouchSlop();
        this.configDefaultIcons();
    }

    public static final /* synthetic */ void access$addStickerImmediately(StickerView $this, Sticker sticker, int position) {
        $this.addStickerImmediately(sticker, position);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

