/*
 * Decompiled with CFR 0.152.
 */
package com.outsbook.libs.canvaseditor.stickers;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b \u0018\u0000 S2\u00020\u0001:\u0001SB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000eJ\u000e\u00108\u001a\u00020 2\u0006\u0010;\u001a\u00020\bJ\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H&J\u0010\u0010\u0005\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0004H\u0002J\b\u0010A\u001a\u00020\bH\u0002J\u000e\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020=2\u0006\u0010@\u001a\u00020\nJ\u0018\u0010'\u001a\u00020=2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u001e\u0010-\u001a\u00020=2\u0006\u0010@\u001a\u00020\n2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bJ\u000e\u0010E\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bJ\u0016\u0010E\u001a\u00020=2\u0006\u0010@\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bJ\u0010\u0010F\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u0010H\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010I\u001a\u00020\u001cH\u0002J\u0010\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u001cH&J\u0010\u0010L\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H&J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010N\u001a\u00020 J\u0010\u0010O\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010/J\u0018\u0010P\u001a\u00020=2\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0006R\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00106\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u001e\u00a8\u0006T"}, d2={"Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "", "()V", "bound", "Landroid/graphics/RectF;", "getBound", "()Landroid/graphics/RectF;", "boundPoints", "", "centerPoint", "Landroid/graphics/PointF;", "getCenterPoint", "()Landroid/graphics/PointF;", "currentAngle", "", "getCurrentAngle", "()F", "currentHeight", "getCurrentHeight", "currentScale", "getCurrentScale", "currentWidth", "getCurrentWidth", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "height", "", "getHeight", "()I", "isFlippedHorizontally", "", "()Z", "setFlippedHorizontally", "(Z)V", "isFlippedVertically", "setFlippedVertically", "mappedBound", "getMappedBound", "mappedBoundPoints", "getMappedBoundPoints", "()[F", "mappedBounds", "mappedCenterPoint", "getMappedCenterPoint", "matrix", "Landroid/graphics/Matrix;", "getMatrix", "()Landroid/graphics/Matrix;", "matrixValues", "trappedRect", "unrotatedPoint", "unrotatedWrapperCorner", "width", "getWidth", "contains", "x", "y", "point", "draw", "", "canvas", "Landroid/graphics/Canvas;", "dst", "getBoundPoints", "points", "mappedPoints", "src", "getMappedPoints", "getMatrixAngle", "getMatrixScale", "getMatrixValue", "valueIndex", "setAlpha", "alpha", "setDrawable", "flippedHorizontally", "flippedVertically", "setMatrix", "trapToRect", "r", "array", "Companion", "canvaseditor_release"})
public abstract class Sticker {
    @NotNull
    private final Matrix matrix = new Matrix();
    private boolean isFlippedHorizontally;
    private boolean isFlippedVertically;
    private final float[] matrixValues = new float[9];
    private final float[] unrotatedWrapperCorner = new float[8];
    private final float[] unrotatedPoint = new float[2];
    private final float[] boundPoints = new float[8];
    private final float[] mappedBounds = new float[8];
    private final RectF trappedRect = new RectF();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Matrix getMatrix() {
        return this.matrix;
    }

    public final boolean isFlippedHorizontally() {
        return this.isFlippedHorizontally;
    }

    public final void setFlippedHorizontally(boolean bl) {
        this.isFlippedHorizontally = bl;
    }

    public final boolean isFlippedVertically() {
        return this.isFlippedVertically;
    }

    public final void setFlippedVertically(boolean bl) {
        this.isFlippedVertically = bl;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    @NotNull
    public abstract Drawable getDrawable();

    @NotNull
    public final float[] getMappedBoundPoints() {
        float[] dst = new float[8];
        this.getMappedPoints(dst, this.getBoundPoints());
        return dst;
    }

    private final RectF getBound() {
        RectF bound = new RectF();
        this.getBound(bound);
        return bound;
    }

    @NotNull
    public final RectF getMappedBound() {
        RectF dst = new RectF();
        this.getMappedBound(dst, this.getBound());
        return dst;
    }

    private final PointF getCenterPoint() {
        PointF center = new PointF();
        this.getCenterPoint(center);
        return center;
    }

    @NotNull
    public final PointF getMappedCenterPoint() {
        PointF pointF = this.getCenterPoint();
        this.getMappedCenterPoint(pointF, new float[2], new float[2]);
        return pointF;
    }

    public final float getCurrentScale() {
        return this.getMatrixScale(this.matrix);
    }

    public final float getCurrentHeight() {
        return this.getMatrixScale(this.matrix) * (float)this.getHeight();
    }

    public final float getCurrentWidth() {
        return this.getMatrixScale(this.matrix) * (float)this.getWidth();
    }

    private final float getCurrentAngle() {
        return this.getMatrixAngle(this.matrix);
    }

    public abstract void draw(@NotNull Canvas var1);

    @NotNull
    public abstract Sticker setDrawable(@NotNull Drawable var1);

    @NotNull
    public abstract Sticker setAlpha(int var1);

    @NotNull
    public final Sticker setMatrix(@Nullable Matrix matrix) {
        this.matrix.set(matrix);
        return this;
    }

    @NotNull
    public final Sticker setFlippedHorizontally(boolean flippedHorizontally) {
        this.isFlippedHorizontally = flippedHorizontally;
        return this;
    }

    @NotNull
    public final Sticker setFlippedVertically(boolean flippedVertically) {
        this.isFlippedVertically = flippedVertically;
        return this;
    }

    private final float[] getBoundPoints() {
        float[] points = new float[8];
        this.getBoundPoints(points);
        return points;
    }

    public final void getBoundPoints(@NotNull float[] points) {
        Intrinsics.checkParameterIsNotNull((Object)points, (String)"points");
        if (!this.isFlippedHorizontally) {
            if (!this.isFlippedVertically) {
                points[0] = 0.0f;
                points[1] = 0.0f;
                points[2] = this.getWidth();
                points[3] = 0.0f;
                points[4] = 0.0f;
                points[5] = this.getHeight();
                points[6] = this.getWidth();
                points[7] = this.getHeight();
            } else {
                points[0] = 0.0f;
                points[1] = this.getHeight();
                points[2] = this.getWidth();
                points[3] = this.getHeight();
                points[4] = 0.0f;
                points[5] = 0.0f;
                points[6] = this.getWidth();
                points[7] = 0.0f;
            }
        } else if (!this.isFlippedVertically) {
            points[0] = this.getWidth();
            points[1] = 0.0f;
            points[2] = 0.0f;
            points[3] = 0.0f;
            points[4] = this.getWidth();
            points[5] = this.getHeight();
            points[6] = 0.0f;
            points[7] = this.getHeight();
        } else {
            points[0] = this.getWidth();
            points[1] = this.getHeight();
            points[2] = 0.0f;
            points[3] = this.getHeight();
            points[4] = this.getWidth();
            points[5] = 0.0f;
            points[6] = 0.0f;
            points[7] = 0.0f;
        }
    }

    @NotNull
    public final float[] getMappedPoints(@NotNull float[] src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        float[] dst = new float[src.length];
        this.matrix.mapPoints(dst, src);
        return dst;
    }

    public final void getMappedPoints(@NotNull float[] dst, @NotNull float[] src) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        this.matrix.mapPoints(dst, src);
    }

    private final void getBound(RectF dst) {
        dst.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    private final void getMappedBound(RectF dst, RectF bound) {
        this.matrix.mapRect(dst, bound);
    }

    public final void getCenterPoint(@NotNull PointF dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        dst.set((float)this.getWidth() * 1.0f / (float)2, (float)this.getHeight() * 1.0f / (float)2);
    }

    public final void getMappedCenterPoint(@NotNull PointF dst, @NotNull float[] mappedPoints, @NotNull float[] src) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        Intrinsics.checkParameterIsNotNull((Object)mappedPoints, (String)"mappedPoints");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        this.getCenterPoint(dst);
        src[0] = dst.x;
        src[1] = dst.y;
        this.getMappedPoints(mappedPoints, src);
        dst.set(mappedPoints[0], mappedPoints[1]);
    }

    private final float getMatrixScale(Matrix matrix) {
        double d = this.getMatrixValue(matrix, 0);
        double d2 = 2.0;
        boolean bl = false;
        double d3 = Math.pow(d, d2);
        d = this.getMatrixValue(matrix, 3);
        d2 = 2.0;
        double d4 = d3;
        bl = false;
        double d5 = Math.pow(d, d2);
        d = d4 + d5;
        boolean bl2 = false;
        return (float)Math.sqrt(d);
    }

    private final float getMatrixAngle(Matrix matrix) {
        double d = this.getMatrixValue(matrix, 1);
        double d2 = this.getMatrixValue(matrix, 0);
        boolean bl = false;
        return (float)Math.toDegrees(-Math.atan2(d, d2));
    }

    private final float getMatrixValue(Matrix matrix, int valueIndex) {
        matrix.getValues(this.matrixValues);
        return this.matrixValues[valueIndex];
    }

    public final boolean contains(float x, float y) {
        return this.contains(new float[]{x, y});
    }

    public final boolean contains(@NotNull float[] point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        Matrix tempMatrix = new Matrix();
        tempMatrix.setRotate(-this.getCurrentAngle());
        this.getBoundPoints(this.boundPoints);
        this.getMappedPoints(this.mappedBounds, this.boundPoints);
        tempMatrix.mapPoints(this.unrotatedWrapperCorner, this.mappedBounds);
        tempMatrix.mapPoints(this.unrotatedPoint, point);
        this.trapToRect(this.trappedRect, this.unrotatedWrapperCorner);
        return this.trappedRect.contains(this.unrotatedPoint[0], this.unrotatedPoint[1]);
    }

    private final void trapToRect(RectF r, float[] array) {
        r.set(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getNEGATIVE_INFINITY(), FloatCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
        for (int i = 1; i < array.length; i += 2) {
            float x = (float)MathKt.roundToInt((float)(array[i - 1] * (float)10)) / 10.0f;
            float y = (float)MathKt.roundToInt((float)(array[i] * (float)10)) / 10.0f;
            r.left = x < r.left ? x : r.left;
            r.top = y < r.top ? y : r.top;
            r.right = x > r.right ? x : r.right;
            r.bottom = y > r.bottom ? y : r.bottom;
        }
        r.sort();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/outsbook/libs/canvaseditor/stickers/Sticker$Companion;", "", "()V", "getMatrix", "Landroid/graphics/Matrix;", "sticker", "Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "canvaseditor_release"})
    public static final class Companion {
        @NotNull
        public final Matrix getMatrix(@NotNull Sticker sticker) {
            Intrinsics.checkParameterIsNotNull((Object)sticker, (String)"sticker");
            return sticker.getMatrix();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

