/*
 * Decompiled with CFR 0.152.
 */
package com.outsbook.libs.canvaseditor.paints;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import com.outsbook.libs.canvaseditor.enums.DrawType;
import com.outsbook.libs.canvaseditor.listeners.PaintViewListener;
import com.outsbook.libs.canvaseditor.models.DrawObject;
import com.outsbook.libs.canvaseditor.models.PathAndPaint;
import com.outsbook.libs.canvaseditor.stickers.Sticker;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\"J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0013H\u0014J(\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bH\u0014J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0017J\b\u00103\u001a\u00020\"H\u0002J\b\u00104\u001a\u00020\"H\u0002J\b\u00105\u001a\u00020\"H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/outsbook/libs/canvaseditor/paints/PaintView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "paintViewListener", "Lcom/outsbook/libs/canvaseditor/listeners/PaintViewListener;", "(Landroid/content/Context;Lcom/outsbook/libs/canvaseditor/listeners/PaintViewListener;)V", "currentX", "", "currentY", "drawColor", "", "extraBitmap", "Landroid/graphics/Bitmap;", "getExtraBitmap", "()Landroid/graphics/Bitmap;", "setExtraBitmap", "(Landroid/graphics/Bitmap;)V", "extraCanvas", "Landroid/graphics/Canvas;", "gestureDetector", "Landroid/view/GestureDetector;", "isDrawPath", "", "motionTouchEventX", "motionTouchEventY", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "touchTolerance", "drawPath", "", "pathAndPaint", "Lcom/outsbook/libs/canvaseditor/models/PathAndPaint;", "drawSticker", "sticker", "Lcom/outsbook/libs/canvaseditor/stickers/Sticker;", "initCanvas", "onDraw", "canvas", "onSizeChanged", "width", "height", "oldWidth", "oldHeight", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "touchMove", "touchStart", "touchUp", "canvaseditor_release"})
public final class PaintView
extends FrameLayout {
    private final int drawColor;
    private Path path;
    private float motionTouchEventX;
    private float motionTouchEventY;
    private float currentX;
    private float currentY;
    private boolean isDrawPath;
    private final int touchTolerance;
    private Canvas extraCanvas;
    @NotNull
    public Bitmap extraBitmap;
    @NotNull
    private final Paint paint;
    private final GestureDetector gestureDetector;
    private final PaintViewListener paintViewListener;
    private HashMap _$_findViewCache;

    @NotNull
    public final Bitmap getExtraBitmap() {
        Bitmap bitmap = this.extraBitmap;
        if (bitmap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraBitmap");
        }
        return bitmap;
    }

    public final void setExtraBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"<set-?>");
        this.extraBitmap = bitmap;
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    public final void initCanvas() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
        Bitmap bitmap2 = this.extraBitmap = bitmap;
        if (bitmap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraBitmap");
        }
        Canvas canvas = this.extraCanvas = new Canvas(bitmap2);
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraCanvas");
        }
        canvas.drawColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.invalidate();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.initCanvas();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Bitmap bitmap = this.extraBitmap;
        if (bitmap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraBitmap");
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }

    public final void drawPath(@NotNull PathAndPaint pathAndPaint) {
        Intrinsics.checkParameterIsNotNull((Object)pathAndPaint, (String)"pathAndPaint");
        Canvas canvas = this.extraCanvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraCanvas");
        }
        canvas.drawPath(pathAndPaint.getPath(), pathAndPaint.getPaint());
        this.invalidate();
    }

    public final void drawSticker(@NotNull Sticker sticker) {
        Intrinsics.checkParameterIsNotNull((Object)sticker, (String)"sticker");
        Canvas canvas = this.extraCanvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraCanvas");
        }
        sticker.draw(canvas);
        this.invalidate();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.paintViewListener.onTouchEvent(event);
        this.motionTouchEventX = event.getX();
        this.motionTouchEventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.touchStart();
                break;
            }
            case 2: {
                this.touchMove();
                break;
            }
            case 1: {
                this.touchUp();
                break;
            }
        }
        this.gestureDetector.onTouchEvent(event);
        return true;
    }

    private final void touchStart() {
        this.path.reset();
        this.path.moveTo(this.motionTouchEventX, this.motionTouchEventY);
        this.currentX = this.motionTouchEventX;
        this.currentY = this.motionTouchEventY;
    }

    private final void touchMove() {
        float f = this.motionTouchEventX - this.currentX;
        boolean bl = false;
        float dx = Math.abs(f);
        float f2 = this.motionTouchEventY - this.currentY;
        boolean bl2 = false;
        float dy = Math.abs(f2);
        if (dx >= (float)this.touchTolerance || dy >= (float)this.touchTolerance) {
            this.path.quadTo(this.currentX, this.currentY, (this.motionTouchEventX + this.currentX) / (float)2, (this.motionTouchEventY + this.currentY) / (float)2);
            this.currentX = this.motionTouchEventX;
            this.currentY = this.motionTouchEventY;
            Canvas canvas = this.extraCanvas;
            if (canvas == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraCanvas");
            }
            canvas.drawPath(this.path, this.paint);
            this.isDrawPath = true;
        }
        this.invalidate();
    }

    private final void touchUp() {
        if (this.isDrawPath) {
            DrawObject obj = new DrawObject(new PathAndPaint(new Path(this.path), new Paint(this.paint)), null, DrawType.PATH);
            this.paintViewListener.onTouchUp(obj);
        }
        this.invalidate();
        this.path.reset();
        this.isDrawPath = false;
    }

    public PaintView(@NotNull Context context, @NotNull PaintViewListener paintViewListener2) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)paintViewListener2, (String)"paintViewListener");
        super(context);
        this.paintViewListener = paintViewListener2;
        this.drawColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)17170444, null);
        this.path = new Path();
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.touchTolerance = viewConfiguration.getScaledTouchSlop();
        Paint paint2 = new Paint();
        PaintView paintView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setColor(this.drawColor);
        $this$apply.setAntiAlias(true);
        $this$apply.setDither(true);
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeJoin(Paint.Join.ROUND);
        $this$apply.setStrokeCap(Paint.Cap.ROUND);
        $this$apply.setStrokeWidth(10.0f);
        paintView.paint = paint = paint2;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ PaintView this$0;

            public boolean onSingleTapConfirmed(@Nullable MotionEvent event) {
                block0: {
                    MotionEvent motionEvent = event;
                    if (motionEvent == null) break block0;
                    MotionEvent motionEvent2 = motionEvent;
                    boolean bl = false;
                    boolean bl2 = false;
                    MotionEvent it = motionEvent2;
                    boolean bl3 = false;
                    PaintView.access$getPaintViewListener$p(this.this$0).onClick(it.getX(), it.getY());
                }
                return super.onSingleTapConfirmed(event);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public static final /* synthetic */ PaintViewListener access$getPaintViewListener$p(PaintView $this) {
        return $this.paintViewListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

