/*
 * Decompiled with CFR 0.152.
 */
package com.ornach.magicicon;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.view.View;

public class DrawableHelper {
    Builder mBuilder;

    protected DrawableHelper(Builder mBuilder) {
        this.mBuilder = mBuilder;
    }

    protected Drawable setupBackground() {
        Drawable drawable = null;
        GradientDrawable defaultDrawable = new GradientDrawable();
        defaultDrawable.setCornerRadius((float)this.mBuilder.radius);
        defaultDrawable.setColor(this.mBuilder.backgroundColor);
        defaultDrawable.setShape(this.getShape());
        GradientDrawable focusDrawable = new GradientDrawable();
        focusDrawable.setCornerRadius((float)this.mBuilder.radius);
        focusDrawable.setColor(this.mBuilder.focusColor);
        focusDrawable.setShape(this.getShape());
        GradientDrawable disabledDrawable = new GradientDrawable();
        disabledDrawable.setCornerRadius((float)this.mBuilder.radius);
        disabledDrawable.setColor(this.mBuilder.disabledColor);
        disabledDrawable.setShape(this.getShape());
        if (this.mBuilder.borderColor != 0 && this.mBuilder.borderWidth > 0) {
            defaultDrawable.setStroke(this.mBuilder.borderWidth, this.mBuilder.borderColor);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            drawable = this.getRippleDrawable((Drawable)defaultDrawable, (Drawable)focusDrawable, (Drawable)disabledDrawable);
        } else {
            StateListDrawable states = new StateListDrawable();
            GradientDrawable drawable2 = new GradientDrawable();
            drawable2.setCornerRadius((float)this.mBuilder.radius);
            drawable2.setColor(this.mBuilder.focusColor);
            if (this.mBuilder.focusColor != 0) {
                states.addState(new int[]{16842919}, (Drawable)drawable2);
                states.addState(new int[]{16842908}, (Drawable)drawable2);
                states.addState(new int[]{-16842910}, (Drawable)disabledDrawable);
            }
            states.addState(new int[0], (Drawable)defaultDrawable);
            drawable = states;
        }
        return drawable;
    }

    @TargetApi(value=21)
    private Drawable getRippleDrawable(Drawable defaultDrawable, Drawable focusDrawable, Drawable disabledDrawable) {
        if (!this.mBuilder.isEnabled) {
            return disabledDrawable;
        }
        return new RippleDrawable(ColorStateList.valueOf((int)this.mBuilder.focusColor), defaultDrawable, focusDrawable);
    }

    protected void setBackground(View view) {
        Drawable drawable = this.setupBackground();
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    protected void setBackground(View view, boolean isClickable) {
        Drawable drawable = null;
        if (isClickable) {
            drawable = this.setupBackground();
        } else {
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setCornerRadius((float)this.mBuilder.radius);
            gradientDrawable.setColor(this.mBuilder.backgroundColor);
            if (this.mBuilder.borderColor != 0 && this.mBuilder.borderWidth > 0) {
                gradientDrawable.setStroke(this.mBuilder.borderWidth, this.mBuilder.borderColor);
            }
            gradientDrawable.setShape(this.getShape());
            drawable = gradientDrawable;
        }
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    private int getShape() {
        switch (this.mBuilder.shape) {
            case 102: {
                return 1;
            }
        }
        return 0;
    }

    protected static class Builder {
        public int radius = 0;
        public int borderWidth = 0;
        @ColorInt
        public int backgroundColor = 0;
        @ColorInt
        public int focusColor = -3355444;
        @ColorInt
        public int disabledColor = 0;
        @ColorInt
        public int borderColor = 0;
        public boolean isEnabled = true;
        private int shape = 101;

        protected Builder() {
        }

        public int getRadius() {
            return this.radius;
        }

        public Builder setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public int getBorderWidth() {
            return this.borderWidth;
        }

        public Builder setBorderWidth(int borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public int getFocusColor() {
            return this.focusColor;
        }

        public Builder setFocusColor(int focusColor) {
            this.focusColor = focusColor;
            return this;
        }

        public int getDisabledColor() {
            return this.disabledColor;
        }

        public Builder setDisabledColor(int disabledColor) {
            this.disabledColor = disabledColor;
            return this;
        }

        public int getBorderColor() {
            return this.borderColor;
        }

        public Builder setBorderColor(int borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public int getShape() {
            return this.shape;
        }

        public Builder setShape(int shape) {
            this.shape = shape;
            return this;
        }

        public DrawableHelper build() {
            return new DrawableHelper(this);
        }
    }
}

