/*
 * Decompiled with CFR 0.152.
 */
package com.ornach.magicicon;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.ornach.magicicon.DrawableHelper;
import com.ornach.magicicon.FontHelper;
import com.ornach.magicicon.R;

public class IconButton
extends AppCompatImageView {
    public static final int SHAPE_RECTANGLE = 101;
    public static final int SHAPE_OVAL = 102;
    private static final String TAG = IconButton.class.getSimpleName();
    private Typeface awesomeIconTypeFace = null;
    private Context context;
    private int src = 0;
    private int iconColor = 0;
    private String fontAwesome = "";
    private String fontDefault = "";
    private int fontSize = 100;
    private int fpadding = 30;
    private int padding = 30;
    private int paddingLeft = 30;
    private int paddingTop = 30;
    private int paddingRight = 30;
    private int paddingBottom = 30;
    private int backgroundColor = 0;
    private int focusColor = -3355444;
    private int disabledColor = 0;
    private int shape = 101;
    private int borderWidth = 0;
    private int borderColor = 0;
    private float radius = 0.0f;

    public IconButton(Context context) {
        super(context);
        this.context = context;
        this.initializeView();
    }

    public IconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.processAttributes(context, attrs);
        this.initializeView();
    }

    public IconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.processAttributes(context, attrs);
        this.initializeView();
    }

    private void processAttributes(Context context, AttributeSet attrs) {
        if (Build.VERSION.SDK_INT < 17) {
            this.initDefaultAttributes(attrs);
        } else {
            this.initDefaultAttributes17(attrs);
        }
        TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.IconButton, 0, 0);
        this.initAttributes(attrsArray);
        attrsArray.recycle();
    }

    private void initDefaultAttributes(AttributeSet attrs) {
        int[] defAttr = new int[]{16842965, 16842966, 16842967, 16842968, 16842969, 0x1010119};
        TypedArray defAttrsArray = this.context.obtainStyledAttributes(attrs, defAttr);
        if (defAttrsArray.hasValue(0)) {
            this.padding = defAttrsArray.getDimensionPixelSize(0, this.padding);
            Log.e((String)TAG, (String)("Padding " + this.padding + ""));
            this.paddingRight = this.paddingBottom = this.padding;
            this.paddingTop = this.paddingBottom;
            this.paddingLeft = this.paddingBottom;
        }
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(1, this.paddingLeft);
        this.paddingTop = defAttrsArray.getDimensionPixelSize(2, this.paddingTop);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(3, this.paddingRight);
        this.paddingBottom = defAttrsArray.getDimensionPixelSize(4, this.paddingBottom);
        this.src = defAttrsArray.getResourceId(5, this.src);
        defAttrsArray.recycle();
    }

    @RequiresApi(api=17)
    private void initDefaultAttributes17(AttributeSet attrs) {
        int[] defAttr = new int[]{16842965, 16842966, 16842967, 16842968, 16842969, 16843699, 16843700, 0x1010119};
        TypedArray defAttrsArray = this.context.obtainStyledAttributes(attrs, defAttr);
        this.padding = defAttrsArray.getDimensionPixelSize(0, this.padding);
        Log.e((String)TAG, (String)("Padding " + this.padding + ""));
        this.paddingRight = this.paddingBottom = this.padding;
        this.paddingTop = this.paddingBottom;
        this.paddingLeft = this.paddingBottom;
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(1, this.paddingLeft);
        this.paddingTop = defAttrsArray.getDimensionPixelSize(2, this.paddingTop);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(3, this.paddingRight);
        this.paddingBottom = defAttrsArray.getDimensionPixelSize(4, this.paddingBottom);
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(5, this.paddingLeft);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(6, this.paddingRight);
        this.src = defAttrsArray.getResourceId(7, this.src);
        Log.e((String)TAG, (String)("src " + this.src + ""));
        defAttrsArray.recycle();
    }

    private void initAttributes(TypedArray attrs) {
        this.iconColor = attrs.getColor(R.styleable.IconButton_iconColor, this.iconColor);
        this.fontAwesome = attrs.getString(R.styleable.IconButton_fontAwesome);
        this.backgroundColor = attrs.getColor(R.styleable.IconButton_backgroundColor, this.backgroundColor);
        this.focusColor = attrs.getColor(R.styleable.IconButton_focusColor, this.focusColor);
        this.shape = attrs.getInt(R.styleable.IconButton_shape, this.shape);
        this.borderWidth = attrs.getDimensionPixelSize(R.styleable.IconButton_borderWidth, this.borderWidth);
        this.borderColor = attrs.getInt(R.styleable.IconButton_borderColor, this.borderColor);
        this.radius = attrs.getDimension(R.styleable.IconButton_radius, this.radius);
    }

    private void initializeView() {
        this.setClickable(true);
        if (!this.isInEditMode()) {
            this.awesomeIconTypeFace = FontHelper.getAwesomeTypeface(this.context);
        }
        this.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        if (this.getDrawable() != null) {
            this.changeBitmapColor();
        } else if (!TextUtils.isEmpty((CharSequence)this.fontAwesome)) {
            this.setImageBitmap(this.textToBitmap(this.fontAwesome, this.fontSize, this.iconColor));
        }
        DrawableHelper helper = new DrawableHelper.Builder().setBackgroundColor(this.backgroundColor).setFocusColor(this.focusColor).setShape(this.shape).setDisabledColor(this.disabledColor).setBorderWidth(this.borderWidth).setBorderColor(this.borderColor).setRadius((int)this.radius).build();
        helper.setBackground((View)this, true);
    }

    private Bitmap textToBitmap(String text, int textSize, int textColor) {
        if (text == null || text.isEmpty()) {
            text = this.fontDefault;
        }
        float tSize = textSize != 0 ? (float)textSize : 100.0f;
        Paint paint = new Paint(1);
        paint.setColor(textColor);
        if (this.awesomeIconTypeFace != null) {
            paint.setTypeface(this.awesomeIconTypeFace);
            paint.setTextSize(tSize + 5.0f);
        } else {
            text = "o";
            paint.setTextSize(100.0f);
        }
        paint.setTextAlign(Paint.Align.LEFT);
        float baseline = -paint.ascent();
        int width = (int)(paint.measureText(text) + 0.5f);
        int height = (int)(baseline + paint.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawText(text, 0.0f, baseline, paint);
        return image;
    }

    private void changeColor() {
        Bitmap sourceBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
    }

    private void changeBitmapColor() {
        if (this.iconColor == 0) {
            return;
        }
        Bitmap sourceBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
        Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)sourceBitmap, (int)0, (int)0, (int)(sourceBitmap.getWidth() - 1), (int)(sourceBitmap.getHeight() - 1));
        Paint p = new Paint();
        LightingColorFilter filter = new LightingColorFilter(this.iconColor, this.iconColor);
        p.setColorFilter((ColorFilter)filter);
        p.setAntiAlias(true);
        Canvas canvas = new Canvas(resultBitmap);
        canvas.drawBitmap(resultBitmap, 0.0f, 0.0f, p);
        this.setImageBitmap(resultBitmap);
    }

    private Bitmap changeColorBitmap() {
        Bitmap sourceBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
        int width = sourceBitmap.getWidth();
        int height = sourceBitmap.getHeight();
        int[] pixels = new int[width * height];
        sourceBitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        Bitmap bmOut = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)sourceBitmap.getConfig());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = y * width + x;
                int pixel = pixels[index];
                if (pixel == 0) continue;
                pixels[index] = this.iconColor;
            }
        }
        bmOut.setPixels(pixels, 0, width, 0, 0, width, height);
        return bmOut;
    }

    private Bitmap getCroppedBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int radius = (h > w ? w : h) / 2;
        canvas.drawCircle((float)(w / 2), (float)(h / 2), (float)(radius - this.borderWidth * 3), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }
}

