/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OPolygonShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OPolygon";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.POLYGON;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass polygon = schema.createAbstractClass(this.getName(), this.superClass(db));
        polygon.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        if (OGlobalConfiguration.SPATIAL_ENABLE_DIRECT_WKT_READER.getValueAsBoolean()) {
            OClass polygonZ = schema.createAbstractClass(this.getName() + "Z", this.superClass(db));
            polygonZ.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        }
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        return this.toShape((Geometry)this.createPolygon(coordinates));
    }

    protected Polygon createPolygon(List<List<List<Number>>> coordinates) {
        Polygon shape;
        if (coordinates.size() == 1) {
            List<List<Number>> coords = coordinates.get(0);
            LinearRing linearRing = this.createLinearRing(coords);
            shape = GEOMETRY_FACTORY.createPolygon(linearRing);
        } else {
            int i = 0;
            LinearRing outerRing = null;
            LinearRing[] holes = new LinearRing[coordinates.size() - 1];
            for (List<List<Number>> coordinate : coordinates) {
                if (i == 0) {
                    outerRing = this.createLinearRing(coordinate);
                } else {
                    holes[i - 1] = this.createLinearRing(coordinate);
                }
                ++i;
            }
            shape = GEOMETRY_FACTORY.createPolygon(outerRing, holes);
        }
        return shape;
    }

    protected LinearRing createLinearRing(List<List<Number>> coords) {
        Coordinate[] crs = new Coordinate[coords.size()];
        int i = 0;
        for (List<Number> points : coords) {
            crs[i] = new Coordinate(points.get(0).doubleValue(), points.get(1).doubleValue());
            ++i;
        }
        return GEOMETRY_FACTORY.createLinearRing(crs);
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        ODocument doc = new ODocument(this.getName());
        Polygon polygon = (Polygon)shape.getGeom();
        List<List<List<Double>>> polyCoordinates = this.coordinatesFromPolygon(polygon);
        doc.field("coordinates", polyCoordinates);
        return doc;
    }

    @Override
    protected ODocument toDoc(JtsGeometry shape, Geometry geometry) {
        if (geometry == null || Double.isNaN(geometry.getCoordinate().getZ())) {
            return this.toDoc(shape);
        }
        ODocument doc = new ODocument(this.getName() + "Z");
        Polygon polygon = (Polygon)shape.getGeom();
        List<List<List<Double>>> polyCoordinates = this.coordinatesFromPolygonZ(geometry);
        doc.field("coordinates", polyCoordinates);
        return doc;
    }

    protected List<List<List<Double>>> coordinatesFromPolygon(Polygon polygon) {
        ArrayList<List<List<Double>>> polyCoordinates = new ArrayList<List<List<Double>>>();
        LinearRing exteriorRing = polygon.getExteriorRing();
        polyCoordinates.add(this.coordinatesFromLineString((LineString)exteriorRing));
        int i = polygon.getNumInteriorRing();
        for (int j = 0; j < i; ++j) {
            LinearRing interiorRingN = polygon.getInteriorRingN(j);
            polyCoordinates.add(this.coordinatesFromLineString((LineString)interiorRingN));
        }
        return polyCoordinates;
    }

    protected List<List<List<Double>>> coordinatesFromPolygonZ(Geometry polygon) {
        ArrayList<List<List<Double>>> polyCoordinates = new ArrayList<List<List<Double>>>();
        for (int i = 0; i < polygon.getNumGeometries(); ++i) {
            polyCoordinates.add(this.coordinatesFromLineStringZ(polygon.getGeometryN(i)));
        }
        return polyCoordinates;
    }

    @Override
    public String asText(ODocument document) {
        if (document.getClassName().equals("OPolygonZ")) {
            List coordinates = (List)document.getProperty("coordinates");
            String result = coordinates.stream().map(poly -> "(" + poly.stream().map(point -> point.stream().map(coord -> this.format((double)coord)).collect(Collectors.joining(" "))).collect(Collectors.joining(", ")) + ")").collect(Collectors.joining(" "));
            return "POLYGON Z (" + result + ")";
        }
        return super.asText(document);
    }
}

