/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.operator;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.lucene.operator.OLuceneOperatorUtil;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import com.orientechnologies.spatial.shape.legacy.OShapeBuilderLegacy;
import com.orientechnologies.spatial.shape.legacy.OShapeBuilderLegacyImpl;
import java.util.List;
import java.util.stream.Stream;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class OLuceneWithinOperator
extends OQueryTargetOperator {
    private OShapeBuilderLegacy<Shape> shapeFactory = OShapeBuilderLegacyImpl.INSTANCE;

    public OLuceneWithinOperator() {
        super("WITHIN", 5, false);
    }

    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        Shape shape1;
        List left = (List)iLeft;
        double lat = ((Number)left.get(0)).doubleValue();
        double lon = ((Number)left.get(1)).doubleValue();
        Point shape = SpatialContext.GEO.makePoint(lon, lat);
        return shape.relate(shape1 = this.shapeFactory.makeShape(new OSpatialCompositeKey((List)iRight), SpatialContext.GEO)) == SpatialRelation.WITHIN;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_OPERATOR;
    }

    public Stream<ORawPair<Object, ORID>> executeIndexQuery(OCommandContext iContext, OIndex index, List<Object> keyParams, boolean ascSortOrder) {
        iContext.setVariable("$luceneIndex", (Object)true);
        return index.getInternal().getRids((Object)new OSpatialCompositeKey(keyParams).setOperation(SpatialOperation.IsWithin)).map(rid -> new ORawPair((Object)new OSpatialCompositeKey(keyParams), rid));
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public OIndexSearchResult getOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        return OLuceneOperatorUtil.buildOIndexSearchResult(iSchemaClass, iCondition, iIndexSearchResults, context);
    }
}

