/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.index;

import com.orientechnologies.lucene.index.OLuceneIndexNotUnique;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneSpatialIndex
extends OLuceneIndexNotUnique {
    private final OShapeFactory shapeFactory = OShapeFactory.INSTANCE;

    public OLuceneSpatialIndex(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
    }

    @Override
    public OLuceneIndexNotUnique put(Object key, OIdentifiable value) {
        if (key == null) {
            return this;
        }
        return super.put(key, value);
    }

    @Override
    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        try {
            return (Iterable)this.storage.callIndexEngine(false, this.indexId, engine -> {
                if (((OLuceneSpatialIndexContainer)engine).isLegacy()) {
                    return OLuceneSpatialIndex.super.interpretTxKeyChanges(changes);
                }
                return OLuceneSpatialIndex.interpretAsSpatial(changes);
            });
        }
        catch (OInvalidIndexEngineIdException e) {
            e.printStackTrace();
            return super.interpretTxKeyChanges(changes);
        }
    }

    @Override
    protected Object encodeKey(Object key) {
        if (key instanceof ODocument) {
            Shape shape = this.shapeFactory.fromDoc((ODocument)key);
            return this.shapeFactory.toGeometry(shape);
        }
        return key;
    }

    @Override
    protected Object decodeKey(Object key) {
        if (key instanceof Geometry) {
            Geometry geom = (Geometry)key;
            return this.shapeFactory.toDoc(geom);
        }
        return key;
    }

    private static Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretAsSpatial(OTransactionIndexChangesPerKey item) {
        List entries = item.getEntriesAsList();
        LinkedHashMap<OIdentifiable, Integer> counters = new LinkedHashMap<OIdentifiable, Integer>();
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : entries) {
            Integer counter = (Integer)counters.get(entry.getValue());
            if (counter == null) {
                counter = 0;
            }
            switch (entry.getOperation()) {
                case PUT: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    break;
                }
                case REMOVE: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter - 1);
                    break;
                }
            }
            counters.put(entry.getValue(), counter);
        }
        OTransactionIndexChangesPerKey changes = new OTransactionIndexChangesPerKey(item.key);
        for (Map.Entry entry : counters.entrySet()) {
            OIdentifiable oIdentifiable = (OIdentifiable)entry.getKey();
            switch ((Integer)entry.getValue()) {
                case 1: {
                    changes.add(oIdentifiable, OTransactionIndexChanges.OPERATION.PUT);
                    break;
                }
                case -1: {
                    changes.add(oIdentifiable, OTransactionIndexChanges.OPERATION.REMOVE);
                }
            }
        }
        return changes.getEntriesAsList();
    }
}

