/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.lucene.collections.OLuceneResultSetEmpty;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.functions.OIndexableSQLFunction;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.spatial.functions.OSpatialFunctionAbstract;
import com.orientechnologies.spatial.index.OLuceneSpatialIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class OSpatialFunctionAbstractIndexable
extends OSpatialFunctionAbstract
implements OIndexableSQLFunction {
    public OSpatialFunctionAbstractIndexable(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMinParams, iMaxParams);
    }

    protected OLuceneSpatialIndex searchForIndex(OFromClause target, OExpression[] args) {
        OMetadataInternal dbMetadata = this.getDb().getMetadata();
        OFromItem item = target.getItem();
        OIdentifier identifier = item.getIdentifier();
        String fieldName = args[0].toString();
        String className = identifier.getStringValue();
        List indices = dbMetadata.getSchema().getClass(className).getIndexes().stream().filter(idx -> idx instanceof OLuceneSpatialIndex).map(idx -> (OLuceneSpatialIndex)idx).filter(idx -> this.intersect(idx.getDefinition().getFields(), Arrays.asList(fieldName))).collect(Collectors.toList());
        if (indices.size() > 1) {
            throw new IllegalArgumentException("too many indices matching given field name: " + String.join((CharSequence)",", fieldName));
        }
        return indices.size() == 0 ? null : (OLuceneSpatialIndex)indices.get(0);
    }

    protected ODatabaseDocumentInternal getDb() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Iterable<OIdentifiable> results(OFromClause target, OExpression[] args, OCommandContext ctx, Object rightValue) {
        Object shape;
        OLuceneSpatialIndex oIndex = this.searchForIndex(target, args);
        if (oIndex == null) {
            return null;
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("geo_filter", this.operator());
        if (args[1].getValue() instanceof OJson) {
            OJson json = (OJson)args[1].getValue();
            ODocument doc = new ODocument().fromJSON(json.toString());
            shape = doc.toMap();
        } else {
            shape = args[1].execute((OIdentifiable)null, ctx);
        }
        if (shape instanceof Collection) {
            int size = ((Collection)shape).size();
            if (size == 0) {
                return new OLuceneResultSetEmpty();
            }
            if (size != 1) throw new OCommandExecutionException("The collection in input cannot be major than 1");
            Object next = ((Collection)shape).iterator().next();
            if (next instanceof OResult) {
                OResult inner = (OResult)next;
                Set propertyNames = inner.getPropertyNames();
                if (propertyNames.size() != 1) return new OLuceneResultSetEmpty();
                Object property = inner.getProperty((String)propertyNames.iterator().next());
                if (property instanceof OResult) {
                    shape = ((OResult)property).toElement();
                }
            }
        }
        if (shape instanceof OResultInternal) {
            shape = ((OResultInternal)shape).toElement();
        }
        queryParams.put("shape", shape);
        this.onAfterParsing(queryParams, args, ctx, rightValue);
        HashSet<String> indexes = (HashSet<String>)ctx.getVariable("involvedIndexes");
        if (indexes == null) {
            indexes = new HashSet<String>();
            ctx.setVariable("involvedIndexes", indexes);
        }
        indexes.add(oIndex.getName());
        return oIndex.getInternal().getRids(queryParams).collect(Collectors.toSet());
    }

    protected void onAfterParsing(Map<String, Object> params, OExpression[] args, OCommandContext ctx, Object rightValue) {
    }

    protected abstract String operator();

    public boolean canExecuteInline(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return this.allowsIndexedExecution(target, operator, rightValue, ctx, args);
    }

    public boolean allowsIndexedExecution(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneSpatialIndex index = this.searchForIndex(target, args);
        return index != null;
    }

    public boolean shouldExecuteAfterSearch(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return false;
    }

    public long estimate(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneSpatialIndex index = this.searchForIndex(target, args);
        return index == null ? -1L : index.size();
    }

    public <T> boolean intersect(List<T> list1, List<T> list2) {
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            return true;
        }
        return false;
    }
}

