/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.spatial.engine.OLuceneGeoSpatialIndexEngine;
import com.orientechnologies.spatial.engine.OLuceneLegacySpatialIndexEngine;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexEngineAbstract;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.spatial.SpatialStrategy;

public class OLuceneSpatialIndexEngineDelegator
implements OLuceneIndexEngine,
OLuceneSpatialIndexContainer {
    private final OStorage storage;
    private final String indexName;
    private OLuceneSpatialIndexEngineAbstract delegate;
    private final int id;

    public OLuceneSpatialIndexEngineDelegator(int id, String name, OStorage storage, int version) {
        this.id = id;
        this.indexName = name;
        this.storage = storage;
    }

    public int getId() {
        return this.id;
    }

    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        if (this.delegate == null) {
            if (OClass.INDEX_TYPE.SPATIAL.name().equalsIgnoreCase(indexType)) {
                this.delegate = indexDefinition.getFields().size() > 1 ? new OLuceneLegacySpatialIndexEngine(this.storage, indexName, this.id, OShapeFactory.INSTANCE) : new OLuceneGeoSpatialIndexEngine(this.storage, indexName, this.id, OShapeFactory.INSTANCE);
                this.delegate.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
            } else {
                throw new IllegalStateException("Invalid index type " + indexType);
            }
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
    }

    public void delete(OAtomicOperation atomicOperation) {
        if (this.delegate != null) {
            this.delegate.delete(atomicOperation);
        }
    }

    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        if (this.delegate != null) {
            this.delegate.load(indexName, valueSerializer, isAutomatic, keySerializer, keyTypes, nullPointerSupport, keySize, engineProperties, encryption);
        }
    }

    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        return this.delegate.remove(atomicOperation, key);
    }

    public void clear(OAtomicOperation atomicOperation) {
        this.delegate.clear(atomicOperation);
    }

    public void close() {
        this.delegate.close();
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        try {
            this.delegate.put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIndexException("Error during insertion of key " + key + " in index " + this.indexName), (Throwable)e);
        }
    }

    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        try {
            this.delegate.update(atomicOperation, key, updater);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIndexException("Error during update of key " + key + " in index " + this.indexName), (Throwable)e);
        }
    }

    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        try {
            return this.delegate.validatedPut(atomicOperation, key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIndexException("Error during insertion of key " + key + " in index " + this.indexName), (Throwable)e);
        }
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return this.delegate.stream(valuesTransformer);
    }

    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return this.delegate.descStream(valuesTransformer);
    }

    public Stream<Object> keyStream() {
        return this.delegate.keyStream();
    }

    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        return this.delegate.size(transformer);
    }

    public boolean hasRangeQuerySupport() {
        return this.delegate.hasRangeQuerySupport();
    }

    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    @Override
    public void onRecordAddedToResultSet(OLuceneQueryContext queryContext, OContextualRecordId recordId, Document ret, ScoreDoc score) {
        this.delegate.onRecordAddedToResultSet(queryContext, recordId, ret, score);
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        return this.delegate.buildDocument(key, value);
    }

    @Override
    public Query buildQuery(Object query) {
        return this.delegate.buildQuery(query);
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.delegate.indexAnalyzer();
    }

    @Override
    public Analyzer queryAnalyzer() {
        return this.delegate.queryAnalyzer();
    }

    @Override
    public boolean remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public IndexSearcher searcher() {
        return this.delegate.searcher();
    }

    @Override
    public void release(IndexSearcher searcher) {
        this.delegate.release(searcher);
    }

    @Override
    public SpatialStrategy strategy() {
        return this.delegate.strategy();
    }

    @Override
    public boolean isLegacy() {
        return this.delegate.isLegacy();
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        return this.delegate.getInTx(key, changes);
    }

    @Override
    public long sizeInTx(OLuceneTxChanges changes) {
        return this.delegate.sizeInTx(changes);
    }

    @Override
    public OLuceneTxChanges buildTxChanges() throws IOException {
        return this.delegate.buildTxChanges();
    }

    @Override
    public Query deleteQuery(Object key, OIdentifiable value) {
        return this.delegate.deleteQuery(key, value);
    }

    @Override
    public boolean isCollectionIndex() {
        return this.delegate.isCollectionIndex();
    }

    public void freeze(boolean throwException) {
        this.delegate.freeze(throwException);
    }

    public void release() {
        this.delegate.release();
    }

    public boolean acquireAtomicExclusiveLock(Object key) {
        return true;
    }

    public String getIndexNameByKey(Object key) {
        return this.delegate.getIndexNameByKey(key);
    }

    public void updateUniqueIndexVersion(Object key) {
    }

    public int getUniqueIndexVersion(Object key) {
        return 0;
    }

    public OLuceneIndexEngine getDelegate() {
        return this.delegate;
    }
}

