/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.engine;

import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexEngineAbstract;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.shape.legacy.OShapeBuilderLegacy;
import com.orientechnologies.spatial.shape.legacy.OShapeBuilderLegacyImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneLegacySpatialIndexEngine
extends OLuceneSpatialIndexEngineAbstract {
    private final OShapeBuilderLegacy legacyBuilder = OShapeBuilderLegacyImpl.INSTANCE;

    public OLuceneLegacySpatialIndexEngine(OStorage storage, String indexName, int id, OShapeBuilder factory) {
        super(storage, indexName, id, factory);
    }

    private Set<OIdentifiable> legacySearch(Object key, OLuceneTxChanges changes) throws IOException {
        if (key instanceof OSpatialCompositeKey) {
            SpatialOperation strategy;
            OSpatialCompositeKey newKey = (OSpatialCompositeKey)((Object)key);
            SpatialOperation spatialOperation = strategy = newKey.getOperation() != null ? newKey.getOperation() : SpatialOperation.Intersects;
            if (SpatialOperation.Intersects.equals(strategy)) {
                return this.searchIntersect(newKey, newKey.getMaxDistance(), newKey.getContext(), changes);
            }
            if (SpatialOperation.IsWithin.equals(strategy)) {
                return this.searchWithin(newKey, newKey.getContext(), changes);
            }
        } else if (key instanceof OCompositeKey) {
            return this.searchIntersect((OCompositeKey)key, 0.0, null, changes);
        }
        throw new OIndexEngineException("Unknown key" + key, null);
    }

    private Set<OIdentifiable> searchIntersect(OCompositeKey key, double distance, OCommandContext context, OLuceneTxChanges changes) throws IOException {
        double lat = (Double)OType.convert(key.getKeys().get(0), Double.class);
        double lng = (Double)OType.convert(key.getKeys().get(1), Double.class);
        SpatialOperation operation = SpatialOperation.Intersects;
        Point p = this.ctx.makePoint(lng, lat);
        SpatialArgs args = new SpatialArgs(operation, (Shape)this.ctx.makeCircle(lng, lat, DistanceUtils.dist2Degrees((double)distance, (double)6371.0087714)));
        Query filterQuery = this.strategy.makeQuery(args);
        IndexSearcher searcher = this.searcher();
        DoubleValuesSource valueSource = this.strategy.makeDistanceValueSource(p);
        Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(searcher);
        BooleanQuery q = new BooleanQuery.Builder().add(filterQuery, BooleanClause.Occur.MUST).add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD).build();
        OLuceneQueryContext queryContext = new OSpatialQueryContext(context, searcher, (Query)q, Arrays.asList(distSort.getSort())).setSpatialArgs(args).withChanges(changes);
        return new OLuceneResultSet(this, queryContext, OLuceneQueryBuilder.EMPTY_METADATA);
    }

    private Set<OIdentifiable> searchWithin(OSpatialCompositeKey key, OCommandContext context, OLuceneTxChanges changes) {
        HashSet result = new HashSet();
        Object shape = this.legacyBuilder.makeShape(key, this.ctx);
        if (shape == null) {
            return null;
        }
        SpatialArgs args = new SpatialArgs(SpatialOperation.IsWithin, shape);
        IndexSearcher searcher = this.searcher();
        Query filterQuery = this.strategy.makeQuery(args);
        BooleanQuery query = new BooleanQuery.Builder().add(filterQuery, BooleanClause.Occur.MUST).add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD).build();
        OLuceneQueryContext queryContext = new OSpatialQueryContext(context, searcher, (Query)query).withChanges(changes);
        return new OLuceneResultSet(this, queryContext, OLuceneQueryBuilder.EMPTY_METADATA);
    }

    @Override
    public void onRecordAddedToResultSet(OLuceneQueryContext queryContext, OContextualRecordId recordId, Document doc, ScoreDoc score) {
        OSpatialQueryContext spatialContext = (OSpatialQueryContext)queryContext;
        if (spatialContext.spatialArgs != null) {
            Point docPoint = (Point)this.ctx.readShape(doc.get(this.strategy.getFieldName()));
            double docDistDEG = this.ctx.getDistCalc().distance(spatialContext.spatialArgs.getShape().getCenter(), docPoint);
            final double docDistInKM = DistanceUtils.degrees2Dist((double)docDistDEG, (double)6378.137);
            recordId.setContext((Map)new HashMap<String, Object>(){
                {
                    this.put("distance", docDistInKM);
                }
            });
        }
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        try {
            this.updateLastAccess();
            this.openIfClosed();
            return this.legacySearch(key, changes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object get(Object key) {
        return this.getInTx(key, null);
    }

    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        if (key instanceof OCompositeKey) {
            this.updateLastAccess();
            this.openIfClosed();
            OCompositeKey compositeKey = (OCompositeKey)key;
            Collection container = (Collection)value;
            for (OIdentifiable oIdentifiable : container) {
                this.addDocument(this.newGeoDocument(oIdentifiable, (Shape)this.legacyBuilder.makeShape(compositeKey, this.ctx)));
            }
        }
    }

    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        throw new UnsupportedOperationException();
    }

    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        throw new UnsupportedOperationException("Validated put is not supported by OLuceneLegacySpatialIndexEngine");
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        return this.newGeoDocument(value, (Shape)this.legacyBuilder.makeShape((OCompositeKey)key, this.ctx));
    }

    @Override
    protected SpatialStrategy createSpatialStrategy(OIndexDefinition indexDefinition, ODocument metadata) {
        return new RecursivePrefixTreeStrategy((SpatialPrefixTree)new GeohashPrefixTree(this.ctx, 11), "location");
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    public void updateUniqueIndexVersion(Object key) {
    }

    public int getUniqueIndexVersion(Object key) {
        return 0;
    }
}

