/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.collections.OLuceneResultSetEmpty;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexEngineAbstract;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.spatial.SpatialStrategy;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneGeoSpatialIndexEngine
extends OLuceneSpatialIndexEngineAbstract {
    public OLuceneGeoSpatialIndexEngine(OStorage storage, String name, int id, OShapeBuilder factory) {
        super(storage, name, id, factory);
    }

    @Override
    protected SpatialStrategy createSpatialStrategy(OIndexDefinition indexDefinition, ODocument metadata) {
        return this.strategyFactory.createStrategy(this.ctx, OLuceneGeoSpatialIndexEngine.getDatabase(), indexDefinition, metadata);
    }

    public Object get(Object key) {
        return this.getInTx(key, null);
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            if (key instanceof Map) {
                return this.newGeoSearch((Map)key, changes);
            }
        }
        catch (Exception e) {
            if (e instanceof OException) {
                OException forward = (OException)e;
                throw forward;
            }
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing lucene query"), (Throwable)e);
        }
        return new OLuceneResultSetEmpty();
    }

    private Set<OIdentifiable> newGeoSearch(Map<String, Object> key, OLuceneTxChanges changes) throws Exception {
        OLuceneQueryContext queryContext = this.queryStrategy.build(key).withChanges(changes);
        return new OLuceneResultSet(this, queryContext, OLuceneQueryBuilder.EMPTY_METADATA);
    }

    @Override
    public void onRecordAddedToResultSet(OLuceneQueryContext queryContext, OContextualRecordId recordId, Document doc, ScoreDoc score) {
        OSpatialQueryContext spatialContext = (OSpatialQueryContext)queryContext;
        if (spatialContext.spatialArgs != null) {
            this.updateLastAccess();
            this.openIfClosed();
            Point docPoint = (Point)this.ctx.readShape(doc.get(this.strategy.getFieldName()));
            double docDistDEG = this.ctx.getDistCalc().distance(spatialContext.spatialArgs.getShape().getCenter(), docPoint);
            final double docDistInKM = DistanceUtils.degrees2Dist((double)docDistDEG, (double)6378.137);
            recordId.setContext((Map)new HashMap<String, Object>(){
                {
                    this.put("distance", docDistInKM);
                }
            });
        }
    }

    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        if (key instanceof OIdentifiable) {
            this.openIfClosed();
            ODocument location = (ODocument)((OIdentifiable)key).getRecord();
            Collection container = (Collection)value;
            for (OIdentifiable oIdentifiable : container) {
                this.updateLastAccess();
                this.addDocument(this.newGeoDocument(oIdentifiable, (Shape)this.factory.fromDoc(location)));
            }
        }
    }

    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        throw new UnsupportedOperationException();
    }

    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        throw new UnsupportedOperationException("Validated put is not supported by OLuceneGeoSpatialIndexEngine");
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        ODocument location = (ODocument)((OIdentifiable)key).getRecord();
        return this.newGeoDocument(value, (Shape)this.factory.fromDoc(location));
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    public void updateUniqueIndexVersion(Object key) {
    }

    public int getUniqueIndexVersion(Object key) {
        return 0;
    }
}

