/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.tx.OLuceneTxChangesAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class OLuceneTxChangesSingleRid
extends OLuceneTxChangesAbstract {
    private final Set<String> deleted = new HashSet<String>();
    private final Set<String> updated = new HashSet<String>();
    private final Set<Document> deletedDocs = new HashSet<Document>();

    public OLuceneTxChangesSingleRid(OLuceneIndexEngine engine, IndexWriter writer, IndexWriter deletedIdx) {
        super(engine, writer, deletedIdx);
    }

    @Override
    public void put(Object key, OIdentifiable value, Document doc) {
        if (this.deleted.remove(value.getIdentity().toString())) {
            doc.add((IndexableField)OLuceneIndexType.createField("_tmp_rid", value.getIdentity().toString(), Field.Store.YES));
            this.updated.add(value.getIdentity().toString());
        }
        try {
            this.writer.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("unable to add document to changes index"), (Throwable)e);
        }
    }

    @Override
    public void remove(Object key, OIdentifiable value) {
        try {
            if (value.getIdentity().isTemporary()) {
                this.writer.deleteDocuments(new Query[]{this.engine.deleteQuery(key, value)});
            } else {
                this.deleted.add(value.getIdentity().toString());
                Document doc = this.engine.buildDocument(key, value);
                this.deletedDocs.add(doc);
                this.deletedIdx.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("Error while deleting documents in transaction from lucene index"), (Throwable)e);
        }
    }

    @Override
    public long numDocs() {
        return this.searcher().getIndexReader().numDocs() - this.deleted.size() - this.updated.size();
    }

    @Override
    public Set<Document> getDeletedDocs() {
        return this.deletedDocs;
    }

    @Override
    public boolean isDeleted(Document document, Object key, OIdentifiable value) {
        return this.deleted.contains(value.getIdentity().toString());
    }

    @Override
    public boolean isUpdated(Document document, Object key, OIdentifiable value) {
        return this.updated.contains(value.getIdentity().toString());
    }
}

