/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.functions.OLuceneFunctionsUtils;
import com.orientechnologies.lucene.functions.OLuceneSearchFunctionTemplate;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;

public class OLuceneSearchOnClassFunction
extends OLuceneSearchFunctionTemplate {
    public static final String NAME = "search_class";

    public OLuceneSearchOnClassFunction() {
        super(NAME, 1, 2);
    }

    public String getName() {
        return NAME;
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] params, OCommandContext ctx) {
        Object result = iThis instanceof OResult ? (OResult)iThis : new OResultInternal((OIdentifiable)iThis);
        OElement element = result.toElement();
        String className = ((OClass)element.getSchemaType().get()).getName();
        OLuceneFullTextIndex index = this.searchForIndex(ctx, className);
        if (index == null) {
            return false;
        }
        String query = (String)params[0];
        MemoryIndex memoryIndex = OLuceneFunctionsUtils.getOrCreateMemoryIndex(ctx);
        List key = index.getDefinition().getFields().stream().map(s -> element.getProperty(s)).collect(Collectors.toList());
        for (IndexableField field : index.buildDocument(key).getFields()) {
            memoryIndex.addField(field, index.indexAnalyzer());
        }
        ODocument metadata = this.getMetadata(params);
        OLuceneKeyAndMetadata keyAndMetadata = new OLuceneKeyAndMetadata(new OLuceneCompositeKey(Arrays.asList(query)).setContext(ctx), metadata);
        return memoryIndex.search(index.buildQuery(keyAndMetadata)) > 0.0f;
    }

    private ODocument getMetadata(Object[] params) {
        if (params.length == 2) {
            return new ODocument().fromMap((Map)params[1]);
        }
        return OLuceneQueryBuilder.EMPTY_METADATA;
    }

    public String getSyntax() {
        return "SEARCH_INDEX( indexName, [ metdatada {} ] )";
    }

    public boolean filterResult() {
        return true;
    }

    public Iterable<OIdentifiable> searchFromTarget(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx, new OExpression[0]);
        OExpression expression = args[0];
        String query = (String)expression.execute((OIdentifiable)null, ctx);
        if (index != null) {
            List<OIdentifiable> luceneResultSet;
            ODocument metadata = this.getMetadata(args, ctx);
            try (Stream rids = index.getInternal().getRids((Object)new OLuceneKeyAndMetadata(new OLuceneCompositeKey(Arrays.asList(query)).setContext(ctx), metadata));){
                luceneResultSet = rids.collect(Collectors.toList());
            }
            return luceneResultSet;
        }
        return Collections.emptySet();
    }

    private ODocument getMetadata(OExpression[] args, OCommandContext ctx) {
        if (args.length == 2) {
            return this.getMetadata(args[1], ctx);
        }
        return OLuceneQueryBuilder.EMPTY_METADATA;
    }

    @Override
    protected OLuceneFullTextIndex searchForIndex(OFromClause target, OCommandContext ctx, OExpression ... args) {
        OFromItem item = target.getItem();
        String className = item.getIdentifier().getStringValue();
        return this.searchForIndex(ctx, className);
    }

    private OLuceneFullTextIndex searchForIndex(OCommandContext ctx, String className) {
        OMetadata dbMetadata = ctx.getDatabase().activateOnCurrentThread().getMetadata();
        List indices = dbMetadata.getSchema().getClass(className).getIndexes().stream().filter(idx -> idx instanceof OLuceneFullTextIndex).map(idx -> (OLuceneFullTextIndex)idx).collect(Collectors.toList());
        if (indices.size() > 1) {
            throw new IllegalArgumentException("too many full-text indices on given class: " + className);
        }
        return indices.size() == 0 ? null : (OLuceneFullTextIndex)indices.get(0);
    }
}

