/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.lucene.analyzer.OLuceneAnalyzerFactory;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.engine.OLuceneDirectory;
import com.orientechnologies.lucene.engine.OLuceneDirectoryFactory;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.lucene.tx.OLuceneTxChangesMultiRid;
import com.orientechnologies.lucene.tx.OLuceneTxChangesSingleRid;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public abstract class OLuceneIndexEngineAbstract
extends OSharedResourceAdaptive
implements OLuceneIndexEngine {
    public static final String RID = "RID";
    public static final String KEY = "KEY";
    private final AtomicLong lastAccess;
    private SearcherManager searcherManager;
    protected OIndexDefinition indexDefinition;
    protected String name;
    private ControlledRealTimeReopenThread<IndexSearcher> nrt;
    protected ODocument metadata;
    protected Version version;
    protected Map<String, Boolean> collectionFields = new HashMap<String, Boolean>();
    private TimerTask commitTask;
    private final AtomicBoolean closed;
    private final OStorage storage;
    private volatile long reopenToken;
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;
    private volatile OLuceneDirectory directory;
    private IndexWriter indexWriter;
    private long flushIndexInterval;
    private long closeAfterInterval;
    private long firstFlushAfter;
    private final int id;

    public OLuceneIndexEngineAbstract(int id, OStorage storage, String name) {
        super(true, 0, true);
        this.id = id;
        this.storage = storage;
        this.name = name;
        this.lastAccess = new AtomicLong(System.currentTimeMillis());
        this.closed = new AtomicBoolean(true);
    }

    public int getId() {
        return this.id;
    }

    protected void updateLastAccess() {
        this.lastAccess.set(System.currentTimeMillis());
    }

    protected void addDocument(Document doc) {
        try {
            this.reopenToken = this.indexWriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on adding new document '%s' to Lucene index", (Throwable)e, new Object[]{doc});
        }
    }

    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        this.indexDefinition = indexDefinition;
        this.metadata = metadata;
        OLuceneAnalyzerFactory fc = new OLuceneAnalyzerFactory();
        this.indexAnalyzer = fc.createAnalyzer(indexDefinition, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, metadata);
        this.queryAnalyzer = fc.createAnalyzer(indexDefinition, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, metadata);
        this.checkCollectionIndex(indexDefinition);
        this.flushIndexInterval = ((Integer)Optional.ofNullable(metadata.getProperty("flushIndexInterval")).orElse(10000)).longValue();
        this.closeAfterInterval = ((Integer)Optional.ofNullable(metadata.getProperty("closeAfterInterval")).orElse(120000)).longValue();
        this.firstFlushAfter = ((Integer)Optional.ofNullable(metadata.getProperty("firstFlushAfter")).orElse(10000)).longValue();
    }

    private void scheduleCommitTask() {
        this.commitTask = Orient.instance().scheduleTask(() -> {
            if (this.shouldClose()) {
                OLuceneIndexEngineAbstract oLuceneIndexEngineAbstract = this;
                synchronized (oLuceneIndexEngineAbstract) {
                    if (!this.shouldClose()) {
                        return;
                    }
                    this.doClose(false);
                }
            }
            if (!this.closed.get()) {
                OLogManager.instance().debug((Object)this, "Flushing index: " + this.indexName(), new Object[0]);
                this.flush();
            }
        }, this.firstFlushAfter, this.flushIndexInterval);
    }

    private boolean shouldClose() {
        return !(this.directory.getDirectory() instanceof RAMDirectory) && System.currentTimeMillis() - this.lastAccess.get() > this.closeAfterInterval;
    }

    private void checkCollectionIndex(OIndexDefinition indexDefinition) {
        List fields = indexDefinition.getFields();
        OClass aClass = OLuceneIndexEngineAbstract.getDatabase().getMetadata().getSchema().getClass(indexDefinition.getClassName());
        for (String field : fields) {
            OProperty property = aClass.getProperty(field);
            if (property.getType().isEmbedded() && property.getLinkedType() != null) {
                this.collectionFields.put(field, true);
                continue;
            }
            this.collectionFields.put(field, false);
        }
    }

    private void reOpen(OStorage storage) throws IOException {
        if (this.indexWriter != null && this.indexWriter.isOpen() && this.directory.getDirectory() instanceof RAMDirectory) {
            return;
        }
        this.open(storage);
    }

    protected static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    private synchronized void open(OStorage storage) throws IOException {
        if (!this.closed.get()) {
            return;
        }
        OLuceneDirectoryFactory directoryFactory = new OLuceneDirectoryFactory();
        this.directory = directoryFactory.createDirectory(storage, this.name, this.metadata);
        this.indexWriter = this.createIndexWriter(this.directory.getDirectory());
        this.searcherManager = new SearcherManager(this.indexWriter, true, true, null);
        this.reopenToken = 0L;
        this.startNRT();
        this.closed.set(false);
        this.flush();
        this.scheduleCommitTask();
        this.addMetadataDocumentIfNotPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMetadataDocumentIfNotPresent() {
        IndexSearcher searcher = this.searcher();
        try {
            TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("_CLASS", "JSON_METADATA")), 1);
            if (topDocs.totalHits == 0L) {
                String metaAsJson = this.metadata.toJSON();
                String defAsJson = this.indexDefinition.toStream().toJSON();
                Document metaDoc = new Document();
                metaDoc.add((IndexableField)new StringField("_META_JSON", metaAsJson, Field.Store.YES));
                metaDoc.add((IndexableField)new StringField("_DEF_JSON", defAsJson, Field.Store.YES));
                metaDoc.add((IndexableField)new StringField("_DEF_CLASS_NAME", this.indexDefinition.getClass().getCanonicalName(), Field.Store.YES));
                metaDoc.add((IndexableField)new StringField("_CLASS", "JSON_METADATA", Field.Store.YES));
                this.addDocument(metaDoc);
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error while retrieving index metadata", (Throwable)e, new Object[0]);
        }
        finally {
            this.release(searcher);
        }
    }

    private void startNRT() {
        this.nrt = new ControlledRealTimeReopenThread(this.indexWriter, (ReferenceManager)this.searcherManager, 60.0, 0.1);
        this.nrt.setDaemon(true);
        this.nrt.start();
    }

    private void closeNRT() {
        if (this.nrt != null) {
            this.nrt.interrupt();
            this.nrt.close();
        }
    }

    private void cancelCommitTask() {
        if (this.commitTask != null) {
            this.commitTask.cancel();
        }
    }

    private void closeSearchManager() throws IOException {
        if (this.searcherManager != null) {
            this.searcherManager.close();
        }
    }

    private void commitAndCloseWriter() throws IOException {
        if (this.indexWriter != null && this.indexWriter.isOpen()) {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.closed.set(true);
        }
    }

    protected abstract IndexWriter createIndexWriter(Directory var1) throws IOException;

    public synchronized void flush() {
        try {
            if (!this.closed.get() && this.indexWriter != null && this.indexWriter.isOpen()) {
                this.indexWriter.commit();
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on flushing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(OAtomicOperation atomicOperation) {
        try {
            OAbstractPaginatedStorage storageLocalAbstract;
            this.updateLastAccess();
            this.openIfClosed(this.storage);
            if (this.indexWriter != null && this.indexWriter.isOpen()) {
                OLuceneIndexEngineAbstract oLuceneIndexEngineAbstract = this;
                synchronized (oLuceneIndexEngineAbstract) {
                    this.doClose(true);
                }
            }
            if ((storageLocalAbstract = (OAbstractPaginatedStorage)this.storage) instanceof OLocalPaginatedStorage) {
                OLocalPaginatedStorage localStorage = (OLocalPaginatedStorage)storageLocalAbstract;
                File storagePath = localStorage.getStoragePath().toFile();
                this.deleteIndexFolder(storagePath);
            }
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OStorageException("Error during deletion of Lucene index " + this.name), (Throwable)e);
        }
    }

    private void deleteIndexFolder(File baseStoragePath) throws IOException {
        String[] files;
        for (String fileName : files = this.directory.getDirectory().listAll()) {
            this.directory.getDirectory().deleteFile(fileName);
        }
        this.directory.getDirectory().close();
        String indexPath = this.directory.getPath();
        if (indexPath != null) {
            File[] indexDirFiles;
            File indexDir = new File(indexPath);
            FileSystem fileSystem = FileSystems.getDefault();
            while (!Files.isSameFile(fileSystem.getPath(baseStoragePath.getCanonicalPath(), new String[0]), fileSystem.getPath(indexDir.getCanonicalPath(), new String[0])) && (indexDirFiles = indexDir.listFiles()) != null && indexDirFiles.length == 0) {
                OFileUtils.deleteRecursively((File)indexDir, (boolean)true);
                indexDir = indexDir.getParentFile();
            }
        }
    }

    @Override
    public String indexName() {
        return this.name;
    }

    @Override
    public abstract void onRecordAddedToResultSet(OLuceneQueryContext var1, OContextualRecordId var2, Document var3, ScoreDoc var4);

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer queryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.updateLastAccess();
        this.openIfClosed();
        Query query = this.deleteQuery(key, value);
        if (query != null) {
            this.deleteDocument(query);
        }
        return true;
    }

    @Override
    public boolean remove(Object key) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            Query query = new QueryParser("", this.queryAnalyzer()).parse((String)key);
            this.deleteDocument(query);
            return true;
        }
        catch (ParseException e) {
            OLogManager.instance().error((Object)this, "Lucene parsing exception", (Throwable)e, new Object[0]);
            return false;
        }
    }

    void deleteDocument(Query query) {
        try {
            this.reopenToken = this.indexWriter.deleteDocuments(new Query[]{query});
            if (!this.indexWriter.hasDeletions()) {
                OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)new OIndexException("Error deleting document"), new Object[]{query});
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)e, new Object[]{query});
        }
    }

    private boolean isCollectionDelete() {
        boolean collectionDelete = false;
        for (Boolean aBoolean : this.collectionFields.values()) {
            collectionDelete = collectionDelete || aBoolean != false;
        }
        return collectionDelete;
    }

    protected synchronized void openIfClosed(OStorage storage) {
        if (this.closed.get()) {
            try {
                this.reOpen(storage);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "error while opening closed index:: " + this.indexName(), (Throwable)e, new Object[0]);
            }
        }
    }

    protected void openIfClosed() {
        this.openIfClosed(OLuceneIndexEngineAbstract.getDatabase().getStorage());
    }

    @Override
    public boolean isCollectionIndex() {
        return this.isCollectionDelete();
    }

    @Override
    public IndexSearcher searcher() {
        try {
            this.updateLastAccess();
            this.openIfClosed();
            this.nrt.waitForGeneration(this.reopenToken);
            return (IndexSearcher)this.searcherManager.acquire();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on get searcher from Lucene index", (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new OLuceneIndexException("Error on get searcher from Lucene index"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeInTx(OLuceneTxChanges changes) {
        this.updateLastAccess();
        this.openIfClosed();
        IndexSearcher searcher = this.searcher();
        try {
            IndexReader reader = searcher.getIndexReader();
            long l = changes == null ? (long)(reader.numDocs() - 1) : (long)reader.numDocs() + changes.numDocs() - 1L;
            return l;
        }
        finally {
            this.release(searcher);
        }
    }

    @Override
    public OLuceneTxChanges buildTxChanges() throws IOException {
        if (this.isCollectionDelete()) {
            return new OLuceneTxChangesMultiRid(this, this.createIndexWriter((Directory)new RAMDirectory()), this.createIndexWriter((Directory)new RAMDirectory()));
        }
        return new OLuceneTxChangesSingleRid(this, this.createIndexWriter((Directory)new RAMDirectory()), this.createIndexWriter((Directory)new RAMDirectory()));
    }

    @Override
    public Query deleteQuery(Object key, OIdentifiable value) {
        this.updateLastAccess();
        this.openIfClosed();
        if (this.isCollectionDelete()) {
            return OLuceneIndexType.createDeleteQuery(value, this.indexDefinition.getFields(), key);
        }
        return OLuceneIndexType.createQueryId(value);
    }

    private void internalDelete() throws IOException {
        OAbstractPaginatedStorage storageLocalAbstract;
        if (this.indexWriter != null && this.indexWriter.isOpen()) {
            this.close();
        }
        if ((storageLocalAbstract = (OAbstractPaginatedStorage)this.storage) instanceof OLocalPaginatedStorage) {
            OLocalPaginatedStorage localPaginatedStorage = (OLocalPaginatedStorage)storageLocalAbstract;
            this.deleteIndexFolder(localPaginatedStorage.getStoragePath().toFile());
        }
    }

    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
    }

    public void clear(OAtomicOperation atomicOperation) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            this.reopenToken = this.indexWriter.deleteAll();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on clearing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public synchronized void close() {
        this.doClose(false);
    }

    private void doClose(boolean onDelete) {
        if (this.closed.get()) {
            return;
        }
        try {
            this.cancelCommitTask();
            this.closeNRT();
            this.closeSearchManager();
            this.commitAndCloseWriter();
            if (!onDelete) {
                this.directory.getDirectory().close();
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on closing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public Stream<Object> keyStream() {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        return this.sizeInTx(null);
    }

    @Override
    public void release(IndexSearcher searcher) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            this.searcherManager.release((Object)searcher);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on releasing index searcher  of Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean acquireAtomicExclusiveLock(Object key) {
        return true;
    }

    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    public synchronized void freeze(boolean throwException) {
        try {
            this.closeNRT();
            this.cancelCommitTask();
            this.commitAndCloseWriter();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on freezing Lucene index:: " + this.indexName(), (Throwable)e, new Object[0]);
        }
    }

    public void release() {
        try {
            this.close();
            this.reOpen(OLuceneIndexEngineAbstract.getDatabase().getStorage());
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on releasing Lucene index:: " + this.indexName(), (Throwable)e, new Object[0]);
        }
    }
}

