/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.analyzer;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.analyzer.OLucenePerFieldAnalyzerWrapper;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class OLuceneAnalyzerFactory {
    public Analyzer createAnalyzer(OIndexDefinition index, AnalyzerKind kind, ODocument metadata) {
        if (index == null) {
            throw new IllegalArgumentException("Index must not be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Analyzer kind must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata must not be null");
        }
        String defaultAnalyzerFQN = (String)metadata.field("default");
        String prefix = index.getClassName() + ".";
        OLucenePerFieldAnalyzerWrapper analyzer = this.geLucenePerFieldPresetAnalyzerWrapperForAllFields(defaultAnalyzerFQN);
        this.setDefaultAnalyzerForRequestedKind(index, kind, metadata, prefix, analyzer);
        this.setSpecializedAnalyzersForEachField(index, kind, metadata, prefix, analyzer);
        return analyzer;
    }

    private OLucenePerFieldAnalyzerWrapper geLucenePerFieldPresetAnalyzerWrapperForAllFields(String defaultAnalyzerFQN) {
        if (defaultAnalyzerFQN == null) {
            return new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        }
        return new OLucenePerFieldAnalyzerWrapper(this.buildAnalyzer(defaultAnalyzerFQN));
    }

    private void setDefaultAnalyzerForRequestedKind(OIndexDefinition index, AnalyzerKind kind, ODocument metadata, String prefix, OLucenePerFieldAnalyzerWrapper analyzer) {
        String specializedAnalyzerFQN = (String)metadata.field(kind.toString());
        if (specializedAnalyzerFQN != null) {
            for (String field : index.getFields()) {
                analyzer.add(field, this.buildAnalyzer(specializedAnalyzerFQN));
                analyzer.add(prefix + field, this.buildAnalyzer(specializedAnalyzerFQN));
            }
        }
    }

    private void setSpecializedAnalyzersForEachField(OIndexDefinition index, AnalyzerKind kind, ODocument metadata, String prefix, OLucenePerFieldAnalyzerWrapper analyzer) {
        for (String field : index.getFields()) {
            String analyzerName = field + "_" + kind.toString();
            String analyzerStopwords = analyzerName + "_stopwords";
            if (metadata.containsField(analyzerName) && metadata.containsField(analyzerStopwords)) {
                Collection stopWords = (Collection)metadata.field(analyzerStopwords, OType.EMBEDDEDLIST);
                analyzer.add(field, this.buildAnalyzer((String)metadata.field(analyzerName), stopWords));
                analyzer.add(prefix + field, this.buildAnalyzer((String)metadata.field(analyzerName), stopWords));
                continue;
            }
            if (!metadata.containsField(analyzerName)) continue;
            analyzer.add(field, this.buildAnalyzer((String)metadata.field(analyzerName)));
            analyzer.add(prefix + field, this.buildAnalyzer((String)metadata.field(analyzerName)));
        }
    }

    private Analyzer buildAnalyzer(String analyzerFQN) {
        try {
            Class<?> classAnalyzer = Class.forName(analyzerFQN);
            Constructor<?> constructor = classAnalyzer.getConstructor(new Class[0]);
            return (Analyzer)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException((OException)new OIndexException("Analyzer: " + analyzerFQN + " not found"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Class<?> classAnalyzer = null;
            try {
                classAnalyzer = Class.forName(analyzerFQN);
                return (Analyzer)classAnalyzer.newInstance();
            }
            catch (Exception e1) {
                OLogManager.instance().error((Object)this, "Exception is suppressed, original exception is ", (Throwable)e, new Object[0]);
                throw OException.wrapException((OException)new OIndexException("Couldn't instantiate analyzer:  public constructor  not found"), (Throwable)e1);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on getting analyzer for Lucene index (continuing with StandardAnalyzer)", (Throwable)e, new Object[0]);
            return new StandardAnalyzer();
        }
    }

    private Analyzer buildAnalyzer(String analyzerFQN, Collection<String> stopwords) {
        try {
            Class<?> classAnalyzer = Class.forName(analyzerFQN);
            Constructor<?> constructor = classAnalyzer.getDeclaredConstructor(CharArraySet.class);
            return (Analyzer)constructor.newInstance(new CharArraySet(stopwords, true));
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException((OException)new OIndexException("Analyzer: " + analyzerFQN + " not found"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw OException.wrapException((OException)new OIndexException("Couldn't instantiate analyzer: public constructor not found"), (Throwable)e);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on getting analyzer for Lucene index (continuing with StandardAnalyzer)", (Throwable)e, new Object[0]);
            return new StandardAnalyzer();
        }
    }

    public static enum AnalyzerKind {
        INDEX,
        QUERY;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

