/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OIncrementalBackupRequest
implements OBinaryRequest<OIncrementalBackupResponse> {
    private String backupDirectory;

    public OIncrementalBackupRequest(String backupDirectory) {
        this.backupDirectory = backupDirectory;
    }

    public OIncrementalBackupRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.backupDirectory);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.backupDirectory = channel.readString();
    }

    @Override
    public byte getCommand() {
        return 27;
    }

    @Override
    public String getDescription() {
        return "Incremental Backup";
    }

    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    @Override
    public OIncrementalBackupResponse createResponse() {
        return new OIncrementalBackupResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeIncrementalBackup(this);
    }
}

