/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OGetClusterDataRangeRequest
implements OBinaryRequest<OGetClusterDataRangeResponse> {
    private int clusterId;

    public OGetClusterDataRangeRequest(int iClusterId) {
        this.clusterId = iClusterId;
    }

    public OGetClusterDataRangeRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeShort((short)this.clusterId);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.clusterId = channel.readShort();
    }

    @Override
    public byte getCommand() {
        return 13;
    }

    @Override
    public String getDescription() {
        return "Get the begin/end range of data in cluster";
    }

    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public OGetClusterDataRangeResponse createResponse() {
        return new OGetClusterDataRangeResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeClusterDataRange(this);
    }
}

