/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCommandResponse;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OCommandRequest
implements OBinaryRequest<OCommandResponse> {
    private ODatabaseDocumentInternal database;
    private boolean asynch;
    private OCommandRequestText query;
    private boolean live;

    public OCommandRequest(ODatabaseDocumentInternal database, boolean asynch, OCommandRequestText iCommand, boolean live) {
        this.database = database;
        this.asynch = asynch;
        this.query = iCommand;
        this.live = live;
    }

    public OCommandRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        if (this.live) {
            network.writeByte((byte)108);
        } else {
            network.writeByte((byte)(this.asynch ? 97 : 115));
        }
        network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream(this.query));
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte type = channel.readByte();
        if (type == 108) {
            this.live = true;
        }
        if (type == 97) {
            this.asynch = true;
        }
        this.query = OStreamSerializerAnyStreamable.INSTANCE.fromStream(channel.readBytes(), serializer);
    }

    @Override
    public byte getCommand() {
        return 41;
    }

    @Override
    public String getDescription() {
        return "Execute remote command";
    }

    public OCommandRequestText getQuery() {
        return this.query;
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    public boolean isLive() {
        return this.live;
    }

    @Override
    public OCommandResponse createResponse() {
        return new OCommandResponse(this.asynch, this.query.getResultListener(), this.database, this.live);
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCommand(this);
    }
}

