/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import com.orhanobut.dialogplus.SimpleAnimationListener;
import com.orhanobut.dialogplus.Utils;

class ExpandTouchListener
implements View.OnTouchListener {
    private final AbsListView absListView;
    private final View contentContainer;
    private final int displayHeight;
    private final int defaultContentHeight;
    private final GestureDetector gestureDetector;
    private final int gravity;
    private float y;
    private boolean fullScreen;
    private boolean touchUp;
    private boolean scrollUp;
    private FrameLayout.LayoutParams params;

    public static ExpandTouchListener newListener(Context context, AbsListView listView, View container, int gravity, int displayHeight, int defaultContentHeight) {
        return new ExpandTouchListener(context, listView, container, gravity, displayHeight, defaultContentHeight);
    }

    private ExpandTouchListener(Context context, AbsListView absListView, View container, int gravity, int displayHeight, int defaultContentHeight) {
        this.absListView = absListView;
        this.contentContainer = container;
        this.gravity = gravity;
        this.displayHeight = displayHeight;
        this.defaultContentHeight = defaultContentHeight;
        this.params = (FrameLayout.LayoutParams)container.getLayoutParams();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                ExpandTouchListener.this.scrollUp = distanceY > 0.0f;
                return false;
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            return false;
        }
        if ((this.scrollUp || !Utils.listIsAtTop(this.absListView)) && this.fullScreen) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.y = event.getRawY();
                return true;
            }
            case 2: {
                if (this.params.height == this.displayHeight) {
                    --this.params.height;
                    this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
                    return false;
                }
                this.onTouchMove(v, event);
                break;
            }
            case 1: {
                this.onTouchUp(v, event);
            }
        }
        return true;
    }

    private void onTouchMove(View view, MotionEvent event) {
        float delta;
        if (this.y == -1.0f) {
            this.y = event.getRawY();
        }
        boolean bl = this.touchUp = (delta = this.y - event.getRawY()) > 0.0f;
        if (this.gravity == 48) {
            delta = -delta;
        }
        this.y = event.getRawY();
        int newHeight = this.params.height + (int)delta;
        if (newHeight > this.displayHeight) {
            newHeight = this.displayHeight;
        }
        if (newHeight < this.defaultContentHeight) {
            newHeight = this.defaultContentHeight;
        }
        this.params.height = newHeight;
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.fullScreen = this.params.height == this.displayHeight;
    }

    private void onTouchUp(View view, MotionEvent event) {
        this.y = -1.0f;
        if (!this.touchUp && this.params.height < this.displayHeight && this.params.height > this.displayHeight * 4 / 5) {
            Utils.animateContent(this.contentContainer, this.displayHeight, new SimpleAnimationListener(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    ExpandTouchListener.this.fullScreen = true;
                }
            });
            return;
        }
        if (this.touchUp && this.params.height > this.defaultContentHeight + 50) {
            Utils.animateContent(this.contentContainer, this.displayHeight, new SimpleAnimationListener(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    ExpandTouchListener.this.fullScreen = true;
                }
            });
            return;
        }
        if (this.touchUp && this.params.height <= this.defaultContentHeight + 50) {
            Utils.animateContent(this.contentContainer, this.defaultContentHeight, new SimpleAnimationListener());
            return;
        }
        if (!this.touchUp && this.params.height > this.defaultContentHeight) {
            Utils.animateContent(this.contentContainer, this.defaultContentHeight, new SimpleAnimationListener());
        }
    }
}

