/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.app.Activity;
import android.content.Context;
import android.view.Display;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import com.orhanobut.dialogplus.DialogPlus;
import com.orhanobut.dialogplus.Holder;
import com.orhanobut.dialogplus.ListHolder;
import com.orhanobut.dialogplus.OnBackPressListener;
import com.orhanobut.dialogplus.OnCancelListener;
import com.orhanobut.dialogplus.OnClickListener;
import com.orhanobut.dialogplus.OnDismissListener;
import com.orhanobut.dialogplus.OnItemClickListener;
import com.orhanobut.dialogplus.R;
import com.orhanobut.dialogplus.Utils;
import java.util.Arrays;

public class DialogPlusBuilder {
    private static final int INVALID = -1;
    private final int[] margin = new int[4];
    private final int[] padding = new int[4];
    private final int[] outMostMargin = new int[4];
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private BaseAdapter adapter;
    private Context context;
    private View footerView;
    private View headerView;
    private Holder holder;
    private int gravity = 80;
    private OnItemClickListener onItemClickListener;
    private OnClickListener onClickListener;
    private OnDismissListener onDismissListener;
    private OnCancelListener onCancelListener;
    private OnBackPressListener onBackPressListener;
    private boolean isCancelable = true;
    private int backgroundColorResourceId = -1;
    private int headerViewResourceId = -1;
    private int footerViewResourceId = -1;
    private int inAnimation = -1;
    private int outAnimation = -1;
    private boolean expanded;
    private int defaultContentHeight;

    private DialogPlusBuilder() {
    }

    DialogPlusBuilder(Context context) {
        if (context == null) {
            throw new NullPointerException("Context may not be null");
        }
        this.context = context;
        Arrays.fill(this.margin, -1);
    }

    public DialogPlusBuilder setAdapter(BaseAdapter adapter) {
        if (adapter == null) {
            throw new NullPointerException("Adapter may not be null");
        }
        this.adapter = adapter;
        return this;
    }

    public DialogPlusBuilder setFooter(int resourceId) {
        this.footerViewResourceId = resourceId;
        return this;
    }

    public DialogPlusBuilder setFooter(View view) {
        this.footerView = view;
        return this;
    }

    public DialogPlusBuilder setHeader(int resourceId) {
        this.headerViewResourceId = resourceId;
        return this;
    }

    public DialogPlusBuilder setHeader(View view) {
        this.headerView = view;
        return this;
    }

    public DialogPlusBuilder setCancelable(boolean isCancelable) {
        this.isCancelable = isCancelable;
        return this;
    }

    public DialogPlusBuilder setContentHolder(Holder holder) {
        this.holder = holder;
        return this;
    }

    public DialogPlusBuilder setBackgroundColorResourceId(int resourceId) {
        this.backgroundColorResourceId = resourceId;
        return this;
    }

    public DialogPlusBuilder setGravity(int gravity) {
        this.gravity = gravity;
        this.params.gravity = gravity;
        return this;
    }

    public DialogPlusBuilder setInAnimation(int inAnimResource) {
        this.inAnimation = inAnimResource;
        return this;
    }

    public DialogPlusBuilder setOutAnimation(int outAnimResource) {
        this.outAnimation = outAnimResource;
        return this;
    }

    public DialogPlusBuilder setOutMostMargin(int left, int top, int right, int bottom) {
        this.outMostMargin[0] = left;
        this.outMostMargin[1] = top;
        this.outMostMargin[2] = right;
        this.outMostMargin[3] = bottom;
        return this;
    }

    @Deprecated
    public DialogPlusBuilder setMargins(int left, int top, int right, int bottom) {
        this.margin[0] = left;
        this.margin[1] = top;
        this.margin[2] = right;
        this.margin[3] = bottom;
        return this;
    }

    public DialogPlusBuilder setMargin(int left, int top, int right, int bottom) {
        this.margin[0] = left;
        this.margin[1] = top;
        this.margin[2] = right;
        this.margin[3] = bottom;
        return this;
    }

    public DialogPlusBuilder setPadding(int left, int top, int right, int bottom) {
        this.padding[0] = left;
        this.padding[1] = top;
        this.padding[2] = right;
        this.padding[3] = bottom;
        return this;
    }

    public DialogPlusBuilder setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
        return this;
    }

    public DialogPlusBuilder setOnClickListener(OnClickListener listener) {
        this.onClickListener = listener;
        return this;
    }

    public DialogPlusBuilder setOnDismissListener(OnDismissListener listener) {
        this.onDismissListener = listener;
        return this;
    }

    public DialogPlusBuilder setOnCancelListener(OnCancelListener listener) {
        this.onCancelListener = listener;
        return this;
    }

    public DialogPlusBuilder setOnBackPressListener(OnBackPressListener listener) {
        this.onBackPressListener = listener;
        return this;
    }

    public DialogPlusBuilder setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public DialogPlusBuilder setExpanded(boolean expanded, int defaultContentHeight) {
        this.expanded = expanded;
        this.defaultContentHeight = defaultContentHeight;
        return this;
    }

    public DialogPlusBuilder setContentHeight(int height) {
        this.params.height = height;
        return this;
    }

    public DialogPlusBuilder setContentWidth(int width) {
        this.params.width = width;
        return this;
    }

    public DialogPlus create() {
        this.init();
        return new DialogPlus(this);
    }

    private void init() {
        if (this.backgroundColorResourceId == -1) {
            this.backgroundColorResourceId = 17170443;
        }
        this.getHolder().setBackgroundColor(this.backgroundColorResourceId);
    }

    public View getFooterView() {
        return Utils.getView(this.context, this.footerViewResourceId, this.footerView);
    }

    public View getHeaderView() {
        return Utils.getView(this.context, this.headerViewResourceId, this.headerView);
    }

    public Holder getHolder() {
        if (this.holder == null) {
            this.holder = new ListHolder();
        }
        return this.holder;
    }

    public Context getContext() {
        return this.context;
    }

    public BaseAdapter getAdapter() {
        return this.adapter;
    }

    public Animation getInAnimation() {
        int res = this.inAnimation == -1 ? Utils.getAnimationResource(this.gravity, true) : this.inAnimation;
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = this.outAnimation == -1 ? Utils.getAnimationResource(this.gravity, false) : this.outAnimation;
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public FrameLayout.LayoutParams getContentParams() {
        if (this.expanded) {
            this.params.height = this.defaultContentHeight;
        }
        return this.params;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public FrameLayout.LayoutParams getOutmostLayoutParams() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.setMargins(this.outMostMargin[0], this.outMostMargin[1], this.outMostMargin[2], this.outMostMargin[3]);
        return params;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    public OnDismissListener getOnDismissListener() {
        return this.onDismissListener;
    }

    public OnCancelListener getOnCancelListener() {
        return this.onCancelListener;
    }

    public OnBackPressListener getOnBackPressListener() {
        return this.onBackPressListener;
    }

    public int[] getContentMargin() {
        int minimumMargin = this.context.getResources().getDimensionPixelSize(R.dimen.default_center_margin);
        for (int i = 0; i < this.margin.length; ++i) {
            this.margin[i] = this.getMargin(this.gravity, this.margin[i], minimumMargin);
        }
        return this.margin;
    }

    public int[] getContentPadding() {
        return this.padding;
    }

    public int getDefaultContentHeight() {
        Activity activity = (Activity)this.context;
        Display display = activity.getWindowManager().getDefaultDisplay();
        int displayHeight = display.getHeight() - Utils.getStatusBarHeight((Context)activity);
        if (this.defaultContentHeight == 0) {
            this.defaultContentHeight = displayHeight * 2 / 5;
        }
        return this.defaultContentHeight;
    }

    private int getMargin(int gravity, int margin, int minimumMargin) {
        switch (gravity) {
            case 17: {
                return margin == -1 ? minimumMargin : margin;
            }
        }
        return margin == -1 ? 0 : margin;
    }
}

