/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.orhanobut.dialogplus.HolderAdapter;
import com.orhanobut.dialogplus.OnHolderListener;
import com.orhanobut.dialogplus.R;

public class GridHolder
implements HolderAdapter,
AdapterView.OnItemClickListener {
    private static final String TAG = GridHolder.class.getSimpleName();
    private final int columnNumber;
    private int backgroundColor;
    private GridView gridView;
    private ViewGroup headerContainer;
    private ViewGroup footerContainer;
    private OnHolderListener listener;
    private View.OnKeyListener keyListener;

    public GridHolder(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public void addHeader(View view) {
        if (view == null) {
            return;
        }
        this.headerContainer.addView(view);
    }

    @Override
    public void addFooter(View view) {
        if (view == null) {
            return;
        }
        this.footerContainer.addView(view);
    }

    @Override
    public void setAdapter(BaseAdapter adapter) {
        this.gridView.setAdapter((ListAdapter)adapter);
    }

    @Override
    public void setBackgroundColor(int colorResource) {
        this.backgroundColor = colorResource;
    }

    @Override
    public View getView(LayoutInflater inflater, ViewGroup parent) {
        View view = inflater.inflate(R.layout.dialog_grid, parent, false);
        this.gridView = (GridView)view.findViewById(R.id.list);
        this.gridView.setBackgroundColor(parent.getResources().getColor(this.backgroundColor));
        this.gridView.setNumColumns(this.columnNumber);
        this.gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.gridView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (GridHolder.this.keyListener == null) {
                    throw new NullPointerException("keyListener should not be null");
                }
                return GridHolder.this.keyListener.onKey(v, keyCode, event);
            }
        });
        this.headerContainer = (ViewGroup)view.findViewById(R.id.header_container);
        this.footerContainer = (ViewGroup)view.findViewById(R.id.footer_container);
        return view;
    }

    @Override
    public void setOnItemClickListener(OnHolderListener listener) {
        this.listener = listener;
    }

    @Override
    public void setOnKeyListener(View.OnKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.listener.onItemClick(parent.getItemAtPosition(position), view, position);
    }
}

