/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.app.Activity;
import android.content.Context;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import com.orhanobut.dialogplus.Holder;
import com.orhanobut.dialogplus.HolderAdapter;
import com.orhanobut.dialogplus.ListHolder;
import com.orhanobut.dialogplus.OnClickListener;
import com.orhanobut.dialogplus.OnHolderListener;
import com.orhanobut.dialogplus.OnItemClickListener;
import com.orhanobut.dialogplus.R;
import com.orhanobut.dialogplus.ViewHolder;

public class DialogPlus {
    private static final String TAG = DialogPlus.class.getSimpleName();
    private static final int INVALID = -1;
    private final ViewGroup rootView;
    private final ViewGroup contentContainer;
    private final Gravity gravity;
    private final ScreenType screenType;
    private final boolean isCancelable;
    private boolean isDismissing;
    private final View topView;
    private final View bottomView;
    private final View footerView;
    private final View headerView;
    private final BaseAdapter adapter;
    private final OnItemClickListener onItemClickListener;
    private final OnClickListener onClickListener;
    private final Holder holder;
    private final ViewGroup decorView;
    private final LayoutInflater inflater;
    private final int backgroundColorResourceId;
    private final int inAnimationResource;
    private final int outAnimationResource;
    private final int marginLeft;
    private final int marginTop;
    private final int marginRight;
    private final int marginBottom;
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                DialogPlus.this.dismiss();
            }
            return false;
        }
    };

    private DialogPlus(Builder builder) {
        this.inflater = LayoutInflater.from((Context)builder.context);
        Activity activity = (Activity)builder.context;
        this.holder = this.getHolder(builder.holder);
        int backgroundColor = builder.backgroundColorResourceId;
        this.backgroundColorResourceId = backgroundColor == -1 ? 17170443 : backgroundColor;
        this.headerView = this.getView(builder.headerViewResourceId, builder.headerView);
        this.footerView = this.getView(builder.footerViewResourceId, builder.footerView);
        this.screenType = builder.screenType;
        this.adapter = builder.adapter;
        this.onItemClickListener = builder.onItemClickListener;
        this.onClickListener = builder.onClickListener;
        this.isCancelable = builder.isCancelable;
        this.gravity = builder.gravity;
        int inAnimation = builder.inAnimation;
        int outAnimation = builder.outAnimation;
        this.inAnimationResource = inAnimation == -1 ? this.getAnimationResource(this.gravity, true) : inAnimation;
        this.outAnimationResource = outAnimation == -1 ? this.getAnimationResource(this.gravity, false) : outAnimation;
        int minimumMargin = activity.getResources().getDimensionPixelSize(R.dimen.default_center_margin);
        this.marginLeft = this.getMargin(this.gravity, builder.marginLeft, minimumMargin);
        this.marginTop = this.getMargin(this.gravity, builder.marginTop, minimumMargin);
        this.marginRight = this.getMargin(this.gravity, builder.marginRight, minimumMargin);
        this.marginBottom = this.getMargin(this.gravity, builder.marginBottom, minimumMargin);
        this.decorView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)this.inflater.inflate(R.layout.base_container, null);
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        this.topView = this.rootView.findViewById(R.id.top_view);
        this.bottomView = this.rootView.findViewById(R.id.bottom_view);
        this.createDialog();
    }

    private int getAnimationResource(Gravity gravity, boolean isInAnimation) {
        switch (gravity) {
            case TOP: {
                return isInAnimation ? R.anim.slide_in_top : R.anim.slide_out_top;
            }
            case BOTTOM: {
                return isInAnimation ? R.anim.slide_in_bottom : R.anim.slide_out_bottom;
            }
            case CENTER: {
                return isInAnimation ? R.anim.fade_in_center : R.anim.fade_out_center;
            }
        }
        return -1;
    }

    private int getMargin(Gravity gravity, int margin, int minimumMargin) {
        switch (gravity) {
            case TOP: 
            case BOTTOM: {
                return margin == -1 ? 0 : margin;
            }
            case CENTER: {
                return margin == -1 ? minimumMargin : margin;
            }
        }
        return 0;
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        View view = this.decorView.findViewById(R.id.outmost_container);
        return view != null;
    }

    public void dismiss() {
        if (this.isDismissing) {
            return;
        }
        Context context = this.decorView.getContext();
        Animation outAnim = AnimationUtils.loadAnimation((Context)context, (int)this.outAnimationResource);
        outAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                DialogPlus.this.decorView.removeView((View)DialogPlus.this.rootView);
                DialogPlus.this.isDismissing = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.contentContainer.startAnimation(outAnim);
        this.isDismissing = true;
    }

    private void createDialog() {
        this.initContentView();
        this.initPosition();
        this.initCancelable();
    }

    private void initContentView() {
        int convertedGravity = this.getGravity();
        View contentView = this.createView(this.inflater);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, convertedGravity);
        params.setMargins(this.marginLeft, this.marginTop, this.marginRight, this.marginBottom);
        contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.contentContainer.addView(contentView);
    }

    private int getGravity() {
        switch (this.gravity) {
            case TOP: {
                return 48;
            }
            case BOTTOM: {
                return 80;
            }
        }
        return 17;
    }

    private void initCancelable() {
        if (!this.isCancelable) {
            return;
        }
        this.topView.setOnTouchListener(this.onCancelableTouchListener);
        this.bottomView.setOnTouchListener(this.onCancelableTouchListener);
    }

    private void initPosition() {
        if (this.screenType == ScreenType.FULL) {
            this.topView.setVisibility(8);
            this.bottomView.setVisibility(8);
            return;
        }
        switch (this.gravity) {
            case TOP: {
                this.bottomView.setVisibility(0);
                this.topView.setVisibility(8);
                break;
            }
            case BOTTOM: {
                this.bottomView.setVisibility(8);
                this.topView.setVisibility(0);
                break;
            }
            default: {
                this.bottomView.setVisibility(0);
                this.topView.setVisibility(0);
            }
        }
    }

    private View createView(LayoutInflater inflater) {
        this.holder.setBackgroundColor(this.backgroundColorResourceId);
        View view = this.holder.getView(inflater, this.rootView);
        if (this.holder instanceof ViewHolder) {
            this.assignClickListenerRecursively(view);
        }
        this.assignClickListenerRecursively(this.headerView);
        this.holder.addHeader(this.headerView);
        this.assignClickListenerRecursively(this.footerView);
        this.holder.addFooter(this.footerView);
        if (this.adapter != null && this.holder instanceof HolderAdapter) {
            HolderAdapter holderAdapter = (HolderAdapter)this.holder;
            holderAdapter.setAdapter(this.adapter);
            holderAdapter.setOnItemClickListener(new OnHolderListener(){

                @Override
                public void onItemClick(Object item, View view, int position) {
                    if (DialogPlus.this.onItemClickListener == null) {
                        return;
                    }
                    DialogPlus.this.onItemClickListener.onItemClick(DialogPlus.this, item, view, position);
                }
            });
        }
        return view;
    }

    public void assignClickListenerRecursively(View parent) {
        if (parent == null) {
            return;
        }
        if (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            int childCount = viewGroup.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = viewGroup.getChildAt(i);
                this.assignClickListenerRecursively(child);
            }
        }
        this.setClickListener(parent);
    }

    private void setClickListener(View view) {
        if (view.getId() == -1) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DialogPlus.this.onClickListener == null) {
                    return;
                }
                DialogPlus.this.onClickListener.onClick(DialogPlus.this, v);
            }
        });
    }

    private Holder getHolder(Holder holder) {
        if (holder == null) {
            holder = new ListHolder();
        }
        return holder;
    }

    private View getView(int resourceId, View view) {
        if (view != null) {
            return view;
        }
        if (resourceId != -1) {
            view = this.inflater.inflate(resourceId, null);
        }
        return view;
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        Context context = this.decorView.getContext();
        Animation inAnim = AnimationUtils.loadAnimation((Context)context, (int)this.inAnimationResource);
        this.contentContainer.startAnimation(inAnim);
        this.contentContainer.requestFocus();
        this.holder.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                switch (event.getAction()) {
                    case 1: {
                        if (keyCode != 4 || !DialogPlus.this.isCancelable) break;
                        DialogPlus.this.dismiss();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static class Builder {
        private BaseAdapter adapter;
        private Context context;
        private View footerView;
        private View headerView;
        private Holder holder;
        private Gravity gravity = Gravity.BOTTOM;
        private ScreenType screenType = ScreenType.HALF;
        private OnItemClickListener onItemClickListener;
        private OnClickListener onClickListener;
        private boolean isCancelable = true;
        private int backgroundColorResourceId = -1;
        private int headerViewResourceId = -1;
        private int footerViewResourceId = -1;
        private int inAnimation = -1;
        private int outAnimation = -1;
        private int marginLeft = -1;
        private int marginTop = -1;
        private int marginRight = -1;
        private int marginBottom = -1;

        private Builder() {
        }

        public Builder(Context context) {
            if (context == null) {
                throw new NullPointerException("Context may not be null");
            }
            this.context = context;
        }

        public Builder setAdapter(BaseAdapter adapter) {
            if (adapter == null) {
                throw new NullPointerException("Adapter may not be null");
            }
            this.adapter = adapter;
            return this;
        }

        public Builder setFooter(int resourceId) {
            this.footerViewResourceId = resourceId;
            return this;
        }

        public Builder setFooter(View view) {
            this.footerView = view;
            return this;
        }

        public Builder setHeader(int resourceId) {
            this.headerViewResourceId = resourceId;
            return this;
        }

        public Builder setHeader(View view) {
            this.headerView = view;
            return this;
        }

        public Builder setCancelable(boolean isCancelable) {
            this.isCancelable = isCancelable;
            return this;
        }

        public Builder setContentHolder(Holder holder) {
            this.holder = holder;
            return this;
        }

        public Builder setBackgroundColorResourceId(int resourceId) {
            this.backgroundColorResourceId = resourceId;
            return this;
        }

        public Builder setGravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setInAnimation(int inAnimResource) {
            this.inAnimation = inAnimResource;
            return this;
        }

        public Builder setOutAnimation(int outAnimResource) {
            this.outAnimation = outAnimResource;
            return this;
        }

        public Builder setScreenType(ScreenType screenType) {
            this.screenType = screenType;
            return this;
        }

        public Builder setMargins(int left, int top, int right, int bottom) {
            this.marginLeft = left;
            this.marginTop = top;
            this.marginRight = right;
            this.marginBottom = bottom;
            return this;
        }

        public Builder setOnItemClickListener(OnItemClickListener listener) {
            this.onItemClickListener = listener;
            return this;
        }

        public Builder setOnClickListener(OnClickListener listener) {
            this.onClickListener = listener;
            return this;
        }

        public DialogPlus create() {
            return new DialogPlus(this);
        }
    }

    public static enum ScreenType {
        HALF,
        FULL;

    }

    public static enum Gravity {
        TOP,
        BOTTOM,
        CENTER;

    }
}

