/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableRegistration
extends Registration {
    private final String name;
    private final String id;
    @Nullable
    private final String address;
    @Nullable
    private final Integer port;
    @Nullable
    private final Registration.RegCheck check;
    private final ImmutableList<Registration.RegCheck> checks;
    private final ImmutableList<String> tags;
    private final ImmutableMap<String, String> meta;
    @Nullable
    private final Boolean enableTagOverride;

    private ImmutableRegistration(String name, String id, @Nullable String address, @Nullable Integer port, @Nullable Registration.RegCheck check, ImmutableList<Registration.RegCheck> checks, ImmutableList<String> tags, ImmutableMap<String, String> meta, @Nullable Boolean enableTagOverride) {
        this.name = name;
        this.id = id;
        this.address = address;
        this.port = port;
        this.check = check;
        this.checks = checks;
        this.tags = tags;
        this.meta = meta;
        this.enableTagOverride = enableTagOverride;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    @JsonProperty(value="Port")
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<Registration.RegCheck> getCheck() {
        return Optional.ofNullable(this.check);
    }

    @JsonProperty(value="Checks")
    public ImmutableList<Registration.RegCheck> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="Tags")
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="EnableTagOverride")
    public Optional<Boolean> getEnableTagOverride() {
        return Optional.ofNullable(this.enableTagOverride);
    }

    public final ImmutableRegistration withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableRegistration((String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withAddress(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"address");
        if (Objects.equals(this.address, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, newValue, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withAddress(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.address, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, value, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.port, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, newValue, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withPort(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, value, this.check, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withCheck(Registration.RegCheck value) {
        Registration.RegCheck newValue = (Registration.RegCheck)Preconditions.checkNotNull((Object)value, (Object)"check");
        if (this.check == newValue) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, newValue, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withCheck(Optional<Registration.RegCheck> optional) {
        Registration.RegCheck value = optional.orElse(null);
        if (this.check == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, value, this.checks, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withChecks(Registration.RegCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withChecks(Iterable<? extends Registration.RegCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue, this.meta, this.enableTagOverride);
    }

    public final ImmutableRegistration withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, (ImmutableMap<String, String>)value, this.enableTagOverride);
    }

    public final ImmutableRegistration withEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, newValue);
    }

    public final ImmutableRegistration withEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableTagOverride, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistration && this.equalTo((ImmutableRegistration)another);
    }

    private boolean equalTo(ImmutableRegistration another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && Objects.equals(this.address, another.address) && Objects.equals(this.port, another.port) && Objects.equals(this.check, another.check) && this.checks.equals(another.checks) && this.tags.equals(another.tags) && this.meta.equals(another.meta) && Objects.equals(this.enableTagOverride, another.enableTagOverride);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.address});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.port});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.check});
        h = h * 17 + this.checks.hashCode();
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + this.meta.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.enableTagOverride});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Registration").omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("address", (Object)this.address).add("port", (Object)this.port).add("check", (Object)this.check).add("checks", this.checks).add("tags", this.tags).add("meta", this.meta).add("enableTagOverride", (Object)this.enableTagOverride).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRegistration fromJson(Json json) {
        Builder builder = ImmutableRegistration.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.check != null) {
            builder.check(json.check);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.enableTagOverride != null) {
            builder.enableTagOverride(json.enableTagOverride);
        }
        return builder.build();
    }

    public static ImmutableRegistration copyOf(Registration instance) {
        if (instance instanceof ImmutableRegistration) {
            return (ImmutableRegistration)instance;
        }
        return ImmutableRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String id;
        @Nullable
        private String address;
        @Nullable
        private Integer port;
        @Nullable
        private Registration.RegCheck check;
        private ImmutableList.Builder<Registration.RegCheck> checksBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> metaBuilder = ImmutableMap.builder();
        @Nullable
        private Boolean enableTagOverride;

        private Builder() {
        }

        public final Builder from(Registration instance) {
            Optional<Registration.RegCheck> checkOptional;
            Optional<Integer> portOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            this.id(instance.getId());
            Optional<String> addressOptional = instance.getAddress();
            if (addressOptional.isPresent()) {
                this.address(addressOptional);
            }
            if ((portOptional = instance.getPort()).isPresent()) {
                this.port(portOptional);
            }
            if ((checkOptional = instance.getCheck()).isPresent()) {
                this.check(checkOptional);
            }
            this.addAllChecks(instance.getChecks());
            this.addAllTags(instance.getTags());
            this.putAllMeta(instance.getMeta());
            Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
            if (enableTagOverrideOptional.isPresent()) {
                this.enableTagOverride(enableTagOverrideOptional);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            return this;
        }

        public final Builder address(Optional<String> address) {
            this.address = address.orElse(null);
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder check(Registration.RegCheck check) {
            this.check = (Registration.RegCheck)Preconditions.checkNotNull((Object)check, (Object)"check");
            return this;
        }

        public final Builder check(Optional<Registration.RegCheck> check) {
            this.check = check.orElse(null);
            return this;
        }

        public final Builder addChecks(Registration.RegCheck element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(Registration.RegCheck ... elements) {
            this.checksBuilder.add((Object[])elements);
            return this;
        }

        public final Builder checks(Iterable<? extends Registration.RegCheck> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<? extends Registration.RegCheck> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public final Builder addTags(String element) {
            this.tagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addTags(String ... elements) {
            this.tagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tags(Iterable<String> elements) {
            this.tagsBuilder = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            this.tagsBuilder.addAll(elements);
            return this;
        }

        public final Builder putMeta(String key, String value) {
            this.metaBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.metaBuilder.put(entry);
            return this;
        }

        public final Builder meta(Map<String, ? extends String> entries) {
            this.metaBuilder = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.metaBuilder.putAll(entries);
            return this;
        }

        public final Builder enableTagOverride(boolean enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
            return this;
        }

        public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride.orElse(null);
            return this;
        }

        public ImmutableRegistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checksBuilder.build(), this.tagsBuilder.build(), this.metaBuilder.build(), this.enableTagOverride);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Registration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Registration {
        @Nullable
        String name;
        @Nullable
        String id;
        Optional<String> address = Optional.empty();
        Optional<Integer> port = Optional.empty();
        Optional<Registration.RegCheck> check = Optional.empty();
        List<Registration.RegCheck> checks = ImmutableList.of();
        List<String> tags = ImmutableList.of();
        @Nullable
        Map<String, String> meta;
        Optional<Boolean> enableTagOverride = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Address")
        public void setAddress(Optional<String> address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(Optional<Integer> port) {
            this.port = port;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<Registration.RegCheck> check) {
            this.check = check;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<Registration.RegCheck> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="EnableTagOverride")
        public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Registration.RegCheck> getCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Registration.RegCheck> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getEnableTagOverride() {
            throw new UnsupportedOperationException();
        }
    }
}

