/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.TransactionOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTransactionOptions
extends TransactionOptions {
    @Nullable
    private final String datacenter;
    private final ConsistencyMode consistencyMode;

    private ImmutableTransactionOptions(Builder builder) {
        this.datacenter = builder.datacenter;
        this.consistencyMode = builder.consistencyMode != null ? builder.consistencyMode : (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)super.getConsistencyMode()), (Object)"consistencyMode"));
    }

    private ImmutableTransactionOptions(@Nullable String datacenter, ConsistencyMode consistencyMode) {
        this.datacenter = datacenter;
        this.consistencyMode = consistencyMode;
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public final ImmutableTransactionOptions withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableTransactionOptions(newValue, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableTransactionOptions(value, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        return new ImmutableTransactionOptions(this.datacenter, (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"consistencyMode")));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionOptions && this.equalTo((ImmutableTransactionOptions)another);
    }

    private boolean equalTo(ImmutableTransactionOptions another) {
        return Objects.equals(this.datacenter, another.datacenter) && this.consistencyMode.equals((Object)another.consistencyMode);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + this.consistencyMode.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionOptions").omitNullValues().add("datacenter", (Object)this.datacenter).add("consistencyMode", (Object)this.consistencyMode).toString();
    }

    public static ImmutableTransactionOptions copyOf(TransactionOptions instance) {
        if (instance instanceof ImmutableTransactionOptions) {
            return (ImmutableTransactionOptions)instance;
        }
        return ImmutableTransactionOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String datacenter;
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        public final Builder from(TransactionOptions instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)consistencyMode), (Object)"consistencyMode"));
            return this;
        }

        public ImmutableTransactionOptions build() {
            return new ImmutableTransactionOptions(this);
        }
    }
}

