/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.model.acl.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableToken
extends Token {
    @Nullable
    private final String id;
    @Nullable
    private final String description;
    private final boolean local;
    private final ImmutableList<Token.PolicyLink> policies;

    private ImmutableToken(@Nullable String id, @Nullable String description, boolean local, ImmutableList<Token.PolicyLink> policies) {
        this.id = id;
        this.description = description;
        this.local = local;
        this.policies = policies;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="Local")
    public boolean local() {
        return this.local;
    }

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=Token.PolicyLink.class)
    public ImmutableList<Token.PolicyLink> policies() {
        return this.policies;
    }

    public final ImmutableToken withId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableToken(newValue, this.description, this.local, this.policies);
    }

    public final ImmutableToken withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableToken(value, this.description, this.local, this.policies);
    }

    public final ImmutableToken withDescription(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableToken(this.id, newValue, this.local, this.policies);
    }

    public final ImmutableToken withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableToken(this.id, value, this.local, this.policies);
    }

    public final ImmutableToken withLocal(boolean value) {
        if (this.local == value) {
            return this;
        }
        return new ImmutableToken(this.id, this.description, value, this.policies);
    }

    public final ImmutableToken withPolicies(Token.PolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableToken(this.id, this.description, this.local, (ImmutableList<Token.PolicyLink>)newValue);
    }

    public final ImmutableToken withPolicies(Iterable<? extends Token.PolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableToken(this.id, this.description, this.local, (ImmutableList<Token.PolicyLink>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToken && this.equalTo((ImmutableToken)another);
    }

    private boolean equalTo(ImmutableToken another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.description, another.description) && this.local == another.local && this.policies.equals(another.policies);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.description});
        h = h * 17 + Booleans.hashCode((boolean)this.local);
        h = h * 17 + this.policies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Token").omitNullValues().add("id", (Object)this.id).add("description", (Object)this.description).add("local", this.local).add("policies", this.policies).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableToken fromJson(Json json) {
        Builder builder = ImmutableToken.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.local != null) {
            builder.local(json.local);
        }
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        return builder.build();
    }

    public static ImmutableToken copyOf(Token instance) {
        if (instance instanceof ImmutableToken) {
            return (ImmutableToken)instance;
        }
        return ImmutableToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCAL = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String description;
        private boolean local;
        private ImmutableList.Builder<Token.PolicyLink> policiesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(Token instance) {
            Optional<String> descriptionOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.local(instance.local());
            this.addAllPolicies(instance.policies());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder local(boolean local) {
            this.local = local;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPolicies(Token.PolicyLink element) {
            this.policiesBuilder.add((Object)element);
            return this;
        }

        public final Builder addPolicies(Token.PolicyLink ... elements) {
            this.policiesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
            this.policiesBuilder = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
            this.policiesBuilder.addAll(elements);
            return this;
        }

        public ImmutableToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToken(this.id, this.description, this.local, this.policiesBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("local");
            }
            return "Cannot build Token, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Token {
        Optional<String> id = Optional.empty();
        Optional<String> description = Optional.empty();
        @Nullable
        Boolean local;
        List<Token.PolicyLink> policies = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Local")
        public void setLocal(boolean local) {
            this.local = local;
        }

        @JsonProperty(value="Policies")
        @JsonDeserialize(as=ImmutableList.class, contentAs=Token.PolicyLink.class)
        public void setPolicies(List<Token.PolicyLink> policies) {
            this.policies = policies;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean local() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.PolicyLink> policies() {
            throw new UnsupportedOperationException();
        }
    }
}

